/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AwsBuilderMethodFinder
extends IssuableSubscriptionVisitor {
    private static final String SDK_CLIENT_TYPE = "software.amazon.awssdk.core.SdkClient";
    private static final String SDK_CLIENT_BUILDER_TYPE = "software.amazon.awssdk.utils.builder.SdkBuilder";
    protected static final String AWS_CLIENT_BUILDER_TYPE = "software.amazon.awssdk.awscore.client.builder.AwsClientBuilder";
    private static final MethodMatchers BUILD_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"software.amazon.awssdk.utils.builder.SdkBuilder"}).names(new String[]{"build"}).addWithoutParametersMatcher().build();

    abstract MethodMatchers getTargetMethod();

    abstract String getIssueMessage();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree invocation = (MethodInvocationTree)tree;
        if (!BUILD_METHOD.matches(invocation)) {
            return;
        }
        if (this.isTargetMethodInvoked(invocation)) {
            return;
        }
        AwsBuilderMethodFinder.getIdentifier(invocation).ifPresentOrElse(identifier -> {
            Symbol symbol = identifier.symbol();
            if (!JUtils.isLocalVariable((Symbol)symbol) || JUtils.isParameter((Symbol)symbol)) {
                return;
            }
            VariableTree declaration = (VariableTree)symbol.declaration();
            ExpressionTree initializer = declaration.initializer();
            if (initializer == null || !initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return;
            }
            MethodInvocationTree initializationChain = (MethodInvocationTree)initializer;
            if (this.isTargetMethodInvoked(initializationChain)) {
                return;
            }
            boolean targetMethodIsInvoked = declaration.symbol().usages().stream().anyMatch(usage -> AwsBuilderMethodFinder.isPassedAsArgument(usage) || this.isTargetMethodInvoked((IdentifierTree)usage));
            if (targetMethodIsInvoked) {
                return;
            }
            this.reportIssue((Tree)declaration, this.getIssueMessage());
        }, () -> this.reportIssue((Tree)invocation, this.getIssueMessage()));
    }

    private boolean isTargetMethodInvoked(MethodInvocationTree invocation) {
        CallChainVisitor visitor = new CallChainVisitor(this.getTargetMethod());
        invocation.accept((TreeVisitor)visitor);
        return visitor.methodIsInvoked;
    }

    private boolean isTargetMethodInvoked(IdentifierTree identifier) {
        ReverseCallChainVisitor visitor = new ReverseCallChainVisitor(this.getTargetMethod());
        identifier.accept((TreeVisitor)visitor);
        return visitor.methodIsInvoked;
    }

    private static Optional<IdentifierTree> getIdentifier(MethodInvocationTree invocation) {
        ExpressionTree expression = invocation.methodSelect();
        while (true) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifier = (IdentifierTree)expression;
                if (identifier.symbol().isVariableSymbol()) {
                    return Optional.of(identifier);
                }
                return Optional.empty();
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree currentInvocation = (MethodInvocationTree)expression;
                expression = currentInvocation.methodSelect();
                continue;
            }
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expression;
            IdentifierTree identifier = memberSelect.identifier();
            if (identifier.symbol().isVariableSymbol()) {
                return Optional.of(identifier);
            }
            expression = memberSelect.expression();
        }
    }

    private static boolean isPassedAsArgument(IdentifierTree identifier) {
        Tree parent = identifier.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS});
    }

    private static class CallChainVisitor
    extends BaseTreeVisitor {
        protected boolean methodIsInvoked;
        private MethodMatchers target;

        CallChainVisitor(MethodMatchers matcher) {
            this.target = matcher;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.inspectCall(tree)) {
                return;
            }
            ExpressionTree expression = tree.methodSelect();
            expression.accept((TreeVisitor)this);
        }

        protected boolean inspectCall(MethodInvocationTree invocation) {
            this.methodIsInvoked = this.target.matches(invocation) || !CallChainVisitor.methodBelongsToSdk(invocation);
            return this.methodIsInvoked;
        }

        private static boolean methodBelongsToSdk(MethodInvocationTree invocation) {
            Symbol owner = invocation.methodSymbol().owner();
            return owner.type().isSubtypeOf(AwsBuilderMethodFinder.SDK_CLIENT_BUILDER_TYPE) || owner.type().isSubtypeOf(AwsBuilderMethodFinder.SDK_CLIENT_TYPE);
        }
    }

    private static class ReverseCallChainVisitor
    extends CallChainVisitor {
        ReverseCallChainVisitor(MethodMatchers matcher) {
            super(matcher);
        }

        public void visitIdentifier(IdentifierTree tree) {
            Tree parent = tree.parent();
            if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                parent.accept((TreeVisitor)this);
            }
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            Tree parent = tree.parent();
            if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                parent.accept((TreeVisitor)this);
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.inspectCall(tree)) {
                return;
            }
            Tree parent = tree.parent();
            if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                parent.accept((TreeVisitor)this);
            }
        }
    }
}

