/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ClassPatternsUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1118")
public class UtilityClassWithPublicConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ClassPatternsUtils.isUtilityClass(classTree) || ClassPatternsUtils.isPrivateInnerClass(classTree)) {
            return;
        }
        boolean hasImplicitPublicConstructor = true;
        for (MethodTree explicitConstructor : UtilityClassWithPublicConstructorCheck.getExplicitConstructors(classTree)) {
            hasImplicitPublicConstructor = false;
            if (!UtilityClassWithPublicConstructorCheck.isPublicConstructor((Tree)explicitConstructor)) continue;
            this.reportIssue((Tree)explicitConstructor.simpleName(), "Hide this public constructor.");
        }
        if (hasImplicitPublicConstructor) {
            this.reportIssue((Tree)classTree.simpleName(), "Add a private constructor to hide the implicit public one.");
        }
    }

    private static List<MethodTree> getExplicitConstructors(ClassTree classTree) {
        return Collections.unmodifiableList(classTree.members().stream().filter(UtilityClassWithPublicConstructorCheck::isConstructor).map(MethodTree.class::cast).collect(Collectors.toList()));
    }

    private static boolean isConstructor(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
    }

    private static boolean isPublicConstructor(Tree tree) {
        return UtilityClassWithPublicConstructorCheck.isConstructor(tree) && UtilityClassWithPublicConstructorCheck.hasPublicModifier((MethodTree)tree);
    }

    private static boolean hasPublicModifier(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PUBLIC);
    }
}

