/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2112")
public class URLHashCodeAndEqualsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_NET_URL = "java.net.URL";
    private static final MethodMatchers URL_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.net.URL"}).names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.net.URL"}).names(new String[]{"hashCode"}).addWithoutParametersMatcher().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            Type variableType;
            VariableTree variableTree = (VariableTree)tree;
            if (variableTree.initializer() != null && URLHashCodeAndEqualsCheck.isSubTypeOfSetOrMap(variableType = variableTree.type().symbolType()) && URLHashCodeAndEqualsCheck.usesURLAsTypeParameter(variableType)) {
                this.reportIssue((Tree)variableTree.type(), "Use the URI class instead.");
            }
        } else if (URL_MATCHERS.matches((MethodInvocationTree)tree)) {
            this.reportIssue(tree, "Use the URI class instead.");
        }
    }

    private static boolean isSubTypeOfSetOrMap(Type type) {
        return type.isSubtypeOf("java.util.Set") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean usesURLAsTypeParameter(Type type) {
        Type firstTypeParameter = URLHashCodeAndEqualsCheck.getFirstTypeParameter(type);
        return firstTypeParameter != null && firstTypeParameter.is(JAVA_NET_URL);
    }

    @CheckForNull
    private static Type getFirstTypeParameter(Type type) {
        if (type.isParameterized()) {
            return (Type)type.typeArguments().get(0);
        }
        return null;
    }
}

