/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S106")
public class SystemOutOrErrUsageCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree mset = (MemberSelectExpressionTree)tree;
        String name = mset.identifier().name();
        if ("out".equals(name) && SystemOutOrErrUsageCheck.isSystem(mset.expression())) {
            this.reportIssue(tree, "Replace this use of System.out by a logger.");
        } else if ("err".equals(name) && SystemOutOrErrUsageCheck.isSystem(mset.expression())) {
            this.reportIssue(tree, "Replace this use of System.err by a logger.");
        }
    }

    private static boolean isSystem(ExpressionTree expression) {
        IdentifierTree identifierTree = null;
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifierTree = (IdentifierTree)expression;
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            identifierTree = ((MemberSelectExpressionTree)expression).identifier();
        }
        return identifierTree != null && "System".equals(identifierTree.name());
    }
}

