/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6207")
public class RedundantRecordMethodsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree targetRecord = (ClassTree)tree;
        List<Symbol.VariableSymbol> components = targetRecord.recordComponents().stream().map(component -> (Symbol.VariableSymbol)component.symbol()).collect(Collectors.toList());
        Set<String> componentNames = components.stream().map(Symbol::name).collect(Collectors.toSet());
        for (Tree member : targetRecord.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                this.checkConstructor((MethodTree)member, components);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            this.checkMethod((MethodTree)member, components, componentNames);
        }
    }

    private void checkConstructor(MethodTree constructor, List<Symbol.VariableSymbol> components) {
        if (constructor.block().body().isEmpty() || RedundantRecordMethodsCheck.onlyDoesSimpleAssignments(constructor, components)) {
            this.reportIssue((Tree)constructor.simpleName(), "Remove this redundant constructor which is the same as a default one.");
        }
    }

    private void checkMethod(MethodTree method, List<Symbol.VariableSymbol> components, Set<String> componentsByName) {
        String methodName = method.symbol().name();
        if (!componentsByName.contains(methodName)) {
            return;
        }
        if (RedundantRecordMethodsCheck.onlyReturnsRawValue(method, components)) {
            this.reportIssue((Tree)method.simpleName(), "Remove this redundant method which is the same as a default one.");
        }
    }

    public static boolean onlyReturnsRawValue(MethodTree method, Collection<Symbol.VariableSymbol> components) {
        Symbol identifierSymbol;
        Optional<ReturnStatementTree> returnStatement = RedundantRecordMethodsCheck.getFirstReturnStatement(method);
        if (!returnStatement.isPresent()) {
            return false;
        }
        ExpressionTree expression = returnStatement.get().expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifierSymbol = ((IdentifierTree)expression).symbol();
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            identifierSymbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
        } else {
            return false;
        }
        return components.stream().anyMatch(arg_0 -> ((Symbol)identifierSymbol).equals(arg_0));
    }

    private static Optional<ReturnStatementTree> getFirstReturnStatement(MethodTree method) {
        return method.block().body().stream().filter(statement -> statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})).map(ReturnStatementTree.class::cast).findFirst();
    }

    public static boolean onlyDoesSimpleAssignments(MethodTree constructor, List<Symbol.VariableSymbol> components) {
        if (constructor.parameters().size() != components.size()) {
            return false;
        }
        List<Symbol.VariableSymbol> parameters = constructor.parameters().stream().map(parameter -> (Symbol.VariableSymbol)parameter.symbol()).collect(Collectors.toList());
        List<AssignmentExpressionTree> assignments = RedundantRecordMethodsCheck.extractAssignments(constructor.block().body());
        HashSet componentsAssignedInConstructor = new HashSet();
        for (AssignmentExpressionTree assignment : assignments) {
            RedundantRecordMethodsCheck.assignsParameterToComponent(assignment, components, parameters).ifPresent(componentsAssignedInConstructor::add);
        }
        return componentsAssignedInConstructor.containsAll(components);
    }

    private static List<AssignmentExpressionTree> extractAssignments(List<StatementTree> statements) {
        return statements.stream().map(RedundantRecordMethodsCheck::extractAssignment).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<AssignmentExpressionTree> extractAssignment(StatementTree statement) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return Optional.empty();
        }
        ExpressionStatementTree initialStatement = (ExpressionStatementTree)statement;
        if (!initialStatement.expression().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return Optional.empty();
        }
        return Optional.of((AssignmentExpressionTree)initialStatement.expression());
    }

    private static Optional<Symbol.VariableSymbol> assignsParameterToComponent(AssignmentExpressionTree assignment, List<Symbol.VariableSymbol> components, List<Symbol.VariableSymbol> parameters) {
        ExpressionTree leftHandSide = assignment.variable();
        if (!leftHandSide.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return Optional.empty();
        }
        Symbol variableSymbol = ((MemberSelectExpressionTree)leftHandSide).identifier().symbol();
        Optional<Symbol.VariableSymbol> component = components.stream().filter(arg_0 -> ((Symbol)variableSymbol).equals(arg_0)).findFirst();
        if (!component.isPresent()) {
            return Optional.empty();
        }
        ExpressionTree rightHandSide = assignment.expression();
        if (!rightHandSide.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.empty();
        }
        Symbol valueSymbol = ((IdentifierTree)rightHandSide).symbol();
        if (parameters.stream().anyMatch(arg_0 -> ((Symbol)valueSymbol).equals(arg_0)) && variableSymbol.name().equals(valueSymbol.name())) {
            return component;
        }
        return Optional.empty();
    }
}

