/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@DeprecatedRuleKey(ruleKey="ObjectFinalizeOverridenCallsSuperFinalizeCheck", repositoryKey="squid")
@Rule(key="S1114")
public class ObjectFinalizeOverridenCallsSuperFinalizeCheck
extends IssuableSubscriptionVisitor {
    private static final String FINALIZE = "finalize";
    private static final MethodMatchers FINALIZE_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"finalize"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        BlockTree blockTree;
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverridenCallsSuperFinalizeCheck.isFinalizeOverriddenMethod(methodTree) && (blockTree = methodTree.block()) != null) {
            MethodInvocationTree lastSuperFinalizeInvocation = ObjectFinalizeOverridenCallsSuperFinalizeCheck.findLastSuperFinalizeInvocation(blockTree);
            if (lastSuperFinalizeInvocation == null) {
                this.reportIssue((Tree)methodTree.simpleName(), "Add a call to super.finalize() at the end of this Object.finalize() implementation.");
            } else if (!ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatement(blockTree, lastSuperFinalizeInvocation)) {
                this.reportIssue((Tree)lastSuperFinalizeInvocation, "Move this super.finalize() call to the end of this Object.finalize() implementation.");
            }
        }
    }

    private static boolean isFinalizeOverriddenMethod(MethodTree methodTree) {
        return FINALIZE_MATCHER.matches(methodTree) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.doesOverrideFinalize((Symbol.TypeSymbol)methodTree.symbol().owner());
    }

    private static boolean doesOverrideFinalize(Symbol.TypeSymbol typeSymbol) {
        Type superClassType = typeSymbol.superClass();
        while (superClassType != null && !superClassType.is("java.lang.Object")) {
            Symbol.TypeSymbol currentClass = superClassType.symbol();
            if (currentClass.lookupSymbols(FINALIZE).stream().anyMatch(arg_0 -> ((MethodMatchers)FINALIZE_MATCHER).matches(arg_0))) {
                return true;
            }
            superClassType = currentClass.superClass();
        }
        return false;
    }

    @Nullable
    private static MethodInvocationTree findLastSuperFinalizeInvocation(BlockTree blockTree) {
        FindLastSuperFinalizeInvocationVisitor visitor = new FindLastSuperFinalizeInvocationVisitor();
        blockTree.accept((TreeVisitor)visitor);
        return visitor.lastSuperFinalizeInvocation;
    }

    private static boolean isLastStatement(BlockTree blockTree, MethodInvocationTree lastStatementTree) {
        if (blockTree.body().stream().anyMatch(statement -> statement.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatementInner(((TryStatementTree)statement).finallyBlock(), lastStatementTree))) {
            return true;
        }
        return ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatementInner(blockTree, lastStatementTree);
    }

    private static boolean isLastStatementInner(@Nullable BlockTree blockTree, MethodInvocationTree lastStatementTree) {
        if (blockTree != null) {
            StatementTree last = (StatementTree)ListUtils.getLast((List)blockTree.body());
            if (last.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                return lastStatementTree.equals((Object)((ExpressionStatementTree)last).expression());
            }
            if (last.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
                return ObjectFinalizeOverridenCallsSuperFinalizeCheck.isLastStatementInner(((TryStatementTree)last).finallyBlock(), lastStatementTree);
            }
        }
        return false;
    }

    private static class FindLastSuperFinalizeInvocationVisitor
    extends BaseTreeVisitor {
        @Nullable
        public MethodInvocationTree lastSuperFinalizeInvocation;

        private FindLastSuperFinalizeInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            MemberSelectExpressionTree mset;
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.FINALIZE.equals((mset = (MemberSelectExpressionTree)tree.methodSelect()).identifier().name()) && mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mset.expression()).name())) {
                this.lastSuperFinalizeInvocation = tree;
            }
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

