/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@DeprecatedRuleKey(ruleKey="IndentationCheck", repositoryKey="squid")
@Rule(key="S1120")
public class IndentationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", description="Number of white-spaces of an indent.", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int excludeIssueAtLine;
    private JavaFileScannerContext context;
    private List<String> fileLines;

    public void scanFile(JavaFileScannerContext context) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = 0;
        this.context = context;
        this.fileLines = context.getFileLines();
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        boolean isAnonymous;
        boolean bl = isAnonymous = tree.simpleName() == null;
        if (!isAnonymous) {
            this.checkIndentation(Collections.singletonList(tree));
        }
        int previousLevel = this.expectedLevel;
        if (isAnonymous) {
            this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)tree.openBraceToken());
            this.expectedLevel = Position.startOf((SyntaxToken)tree.closeBraceToken()).columnOffset();
        }
        this.newBlock();
        this.checkIndentation(tree.members());
        super.visitClass(tree);
        this.leaveNode((Tree)tree);
        this.expectedLevel = previousLevel;
    }

    public void visitBlock(BlockTree tree) {
        this.newBlock();
        int oldExpectedLevel = this.expectedLevel;
        this.adjustBlockForExceptionalParents(tree);
        this.checkIndentation(tree.body());
        super.visitBlock(tree);
        this.expectedLevel = oldExpectedLevel;
        this.leaveNode((Tree)tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.newBlock();
        this.scan((Tree)tree.expression());
        for (CaseGroupTree caseGroupTree : tree.cases()) {
            this.newBlock();
            this.checkCaseGroup(caseGroupTree);
            this.scan((Tree)caseGroupTree);
            this.leaveNode((Tree)caseGroupTree);
        }
        this.leaveNode((Tree)tree);
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        Tree body = lambdaExpressionTree.body();
        if (body.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)body;
            this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)block.openBraceToken());
            int previousLevel = this.expectedLevel;
            this.expectedLevel = Position.startOf((SyntaxToken)block.closeBraceToken()).columnOffset();
            this.scan((Tree)block);
            this.expectedLevel = previousLevel;
        } else {
            this.scan(body);
        }
    }

    private void newBlock() {
        this.expectedLevel += this.indentationLevel;
        this.isBlockAlreadyReported = false;
    }

    private void leaveNode(Tree tree) {
        this.expectedLevel -= this.indentationLevel;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)tree.lastToken());
    }

    private void checkCaseGroup(CaseGroupTree tree) {
        List body;
        List labels = tree.labels();
        if (labels.size() >= 2) {
            CaseLabelTree previousCaseLabelTree = (CaseLabelTree)labels.get(labels.size() - 2);
            this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)previousCaseLabelTree.lastToken());
        }
        if ((body = tree.body()).size() == 1 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.checkCaseGroupSingleBlock(tree);
        } else {
            this.checkCaseGroupMixedStatements(tree);
        }
    }

    private void checkCaseGroupSingleBlock(CaseGroupTree tree) {
        List body = tree.body();
        SyntaxToken separatorToken = ((CaseLabelTree)ListUtils.getLast((List)tree.labels())).colonOrArrowToken();
        int nextOffsetInLine = Position.endOf((SyntaxToken)separatorToken).columnOffset() + 1;
        BlockTree block = (BlockTree)body.get(0);
        Position openBracePosition = Position.startOf((SyntaxToken)block.openBraceToken());
        Position separatorPosition = Position.endOf((SyntaxToken)separatorToken);
        if (openBracePosition.line() == separatorPosition.line()) {
            this.checkIndentation((Tree)block.openBraceToken(), nextOffsetInLine);
            if (block.body().isEmpty()) {
                this.checkIndentationWithOptionalAllowed((Tree)block.closeBraceToken(), this.expectedLevel - this.indentationLevel);
            } else {
                int level = this.checkIndentationWithOptionalAllowed((Tree)block.body().get(0), this.expectedLevel) - this.indentationLevel;
                this.checkIndentation((Tree)block.closeBraceToken(), level);
            }
        } else {
            int level = this.checkIndentationWithOptionalAllowed((Tree)block.openBraceToken(), this.expectedLevel - this.indentationLevel);
            if (!block.body().isEmpty()) {
                this.checkIndentation((Tree)block.body().get(0), level + this.indentationLevel);
            }
            this.checkIndentation((Tree)block.closeBraceToken(), level);
        }
    }

    private void checkCaseGroupMixedStatements(CaseGroupTree tree) {
        List body = tree.body();
        SyntaxToken separatorToken = ((CaseLabelTree)ListUtils.getLast((List)tree.labels())).colonOrArrowToken();
        int nextOffsetInLine = Position.endOf((SyntaxToken)separatorToken).columnOffset() + 1;
        List newBody = body;
        int bodySize = body.size();
        int oldExpectedLevel = this.expectedLevel;
        if (bodySize > 0 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.expectedLevel -= this.indentationLevel;
            this.checkIndentation((Tree)body.get(0), nextOffsetInLine);
            newBody = body.subList(1, bodySize);
        }
        if (bodySize == 1 && "->".equals(separatorToken.text())) {
            this.checkSameOrNextLineIndentation(Position.startOf((SyntaxToken)separatorToken).line(), nextOffsetInLine, (StatementTree)body.get(0));
        } else {
            this.checkIndentation(newBody);
        }
        this.expectedLevel = oldExpectedLevel;
    }

    private void checkSameOrNextLineIndentation(int curLine, int nextOffsetInLine, StatementTree statement) {
        this.checkIndentation((Tree)statement, Position.startOf((Tree)statement).line() == curLine ? nextOffsetInLine : this.expectedLevel);
    }

    private void adjustBlockForExceptionalParents(BlockTree tree) {
        if (Objects.requireNonNull(tree.parent()).is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.expectedLevel = tree.body().isEmpty() ? this.getIndentation(Position.startOf((SyntaxToken)tree.closeBraceToken())) + this.indentationLevel : this.getIndentation(Position.startOf((Tree)((Tree)tree.body().get(0))));
        }
    }

    private void checkIndentation(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.checkIndentation(tree, this.expectedLevel);
        }
    }

    private void checkIndentation(Tree tree, int expectedLevel) {
        Position treeStart = Position.startOf((Tree)tree);
        if (this.getIndentation(treeStart) != expectedLevel) {
            this.addIssue(tree, expectedLevel);
        }
        this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)tree.lastToken());
    }

    private int checkIndentationWithOptionalAllowed(Tree tree, int expectedLevel) {
        boolean isAdditionalIndentation;
        Position treeStart = Position.startOf((Tree)tree);
        int level = this.getIndentation(treeStart);
        boolean bl = isAdditionalIndentation = level == expectedLevel + this.indentationLevel;
        if (level != expectedLevel && !isAdditionalIndentation) {
            this.addIssue(tree, expectedLevel, expectedLevel + this.indentationLevel);
        }
        this.excludeIssueAtLine = LineUtils.startLine((SyntaxToken)tree.lastToken());
        return isAdditionalIndentation ? expectedLevel + this.indentationLevel : expectedLevel;
    }

    void addIssue(Tree tree, Integer ... expectedLevels) {
        Position treeStart = Position.startOf((Tree)tree);
        String messageAfter = Arrays.stream(expectedLevels).map(Object::toString).collect(Collectors.joining(" or "));
        if (!this.isExcluded(tree, treeStart.line())) {
            int level = this.getIndentation(treeStart);
            String message = "Make this line start after " + messageAfter + " spaces instead of " + level + " in order to indent the code consistently. (Indentation level is at " + this.indentationLevel + ".)";
            this.context.addIssue(((JavaTree)tree).getLine(), (JavaCheck)this, message);
            this.isBlockAlreadyReported = true;
        }
    }

    private int getIndentation(Position treeStart) {
        String line = this.fileLines.get(treeStart.lineOffset());
        int level = treeStart.columnOffset();
        int indentLength = Math.min(treeStart.columnOffset(), line.length());
        for (int i = 0; i < indentLength; ++i) {
            if (line.charAt(i) != '\t') continue;
            level += this.indentationLevel - 1;
        }
        return level;
    }

    private boolean isExcluded(Tree node, int nodeLine) {
        return this.excludeIssueAtLine == nodeLine || this.isBlockAlreadyReported || node.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT});
    }
}

