/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.AbstractHardCodedCredentialChecker;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedPasswordCheck
extends AbstractHardCodedCredentialChecker {
    private static final String DEFAULT_PASSWORD_WORDS = "password,passwd,pwd,passphrase,java.naming.security.credentials";
    private static final Pattern URL_PREFIX = Pattern.compile("^\\w{1,8}://");
    private static final Pattern NON_EMPTY_URL_CREDENTIAL = Pattern.compile("(?<user>[^\\s:]*+):(?<password>\\S++)");
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential passwords", defaultValue="password,passwd,pwd,passphrase,java.naming.security.credentials")
    public String passwordWords = "password,passwd,pwd,passphrase,java.naming.security.credentials";

    @Override
    protected String getCredentialWords() {
        return this.passwordWords;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.STRING_LITERAL, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignment((AssignmentExpressionTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    @Override
    protected void handleStringLiteral(LiteralTree tree) {
        String cleanedLiteral = LiteralUtils.trimQuotes((String)tree.value());
        if (HardCodedPasswordCheck.isURLWithCredentials(cleanedLiteral)) {
            this.reportIssue((Tree)tree, "Review this hard-coded URL, which may contain a password.");
        } else {
            super.handleStringLiteral(tree);
        }
    }

    private static boolean isURLWithCredentials(String stringLiteral) {
        if (URL_PREFIX.matcher(stringLiteral).find()) {
            try {
                String userInfo = new URL(stringLiteral).getUserInfo();
                if (userInfo != null) {
                    Matcher matcher = NON_EMPTY_URL_CREDENTIAL.matcher(userInfo);
                    return matcher.matches() && !matcher.group("user").equals(matcher.group("password"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    private void handleMethodInvocation(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (EQUALS_MATCHER.matches(mit) && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.handleEqualsMethod(mit, (MemberSelectExpressionTree)methodSelect);
        } else {
            this.isSettingCredential(mit).ifPresent(settingPassword -> this.report((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (String)settingPassword));
        }
    }

    @Override
    protected void report(Tree tree, String match) {
        this.reportIssue(tree, "'" + match + "' detected in this expression, review this potentially hard-coded password.");
    }

    @Override
    protected boolean isCredentialContainingPattern(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            ExpressionTree methodSelect = ((MethodInvocationTree)expression).methodSelect();
            return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isCredentialContainingPattern(((MemberSelectExpressionTree)methodSelect).expression());
        }
        String literal = ExpressionsHelper.getConstantValueAsString(expression).value();
        return literal == null || super.isCredentialLikeName(literal).isPresent();
    }
}

