/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2165")
public class FinalizeFieldsSetCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (FinalizeFieldsSetCheck.isFinalizeDeclaration(methodTree)) {
            methodTree.accept((TreeVisitor)new AssignmentVisitor());
        }
    }

    private static boolean isFinalizeDeclaration(MethodTree tree) {
        return FinalizeFieldsSetCheck.isMethodNamedFinalize(tree) && FinalizeFieldsSetCheck.hasNoParameters(tree);
    }

    private static boolean isMethodNamedFinalize(MethodTree tree) {
        return "finalize".equals(tree.simpleName().name());
    }

    private static boolean hasNoParameters(MethodTree tree) {
        return tree.parameters().isEmpty();
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (this.isFieldAssignment(tree) && this.isNullAssignment(tree)) {
                FinalizeFieldsSetCheck.this.reportIssue((Tree)tree.expression(), "Remove this nullification of \"" + this.getFieldName(tree) + "\".");
            }
        }

        private boolean isFieldAssignment(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)variable;
                if (!ExpressionUtils.isThis((ExpressionTree)memberSelectExpressionTree.expression())) {
                    return false;
                }
                variable = memberSelectExpressionTree.identifier();
            }
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol variableSymbol = ((IdentifierTree)variable).symbol();
                return variableSymbol.owner().isTypeSymbol();
            }
            return false;
        }

        private boolean isNullAssignment(AssignmentExpressionTree tree) {
            return tree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }

        private String getFieldName(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                variable = ((MemberSelectExpressionTree)variable).identifier();
            }
            return ((IdentifierTree)variable).name();
        }
    }
}

