/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1210")
public class EqualsNotOverridenWithCompareToCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!EqualsNotOverridenWithCompareToCheck.isComparable(classTree)) {
            return;
        }
        boolean hasEquals = false;
        MethodTree compare = null;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            MethodTree method = (MethodTree)member;
            if (EqualsNotOverridenWithCompareToCheck.isEqualsMethod(method)) {
                hasEquals = true;
                continue;
            }
            if (!EqualsNotOverridenWithCompareToCheck.isCompareToMethod(method)) continue;
            compare = method;
        }
        if (compare != null && !hasEquals) {
            this.reportIssue((Tree)compare.simpleName(), "Override \"equals(Object obj)\" to comply with the contract of the \"compareTo(T o)\" method.");
        }
    }

    private static boolean isCompareToMethod(MethodTree method) {
        String name = method.simpleName().name();
        return "compareTo".equals(name) && EqualsNotOverridenWithCompareToCheck.returnsInt(method) && method.parameters().size() == 1;
    }

    private static boolean isEqualsMethod(MethodTree method) {
        return MethodTreeUtils.isEqualsMethod(method);
    }

    private static boolean isComparable(ClassTree tree) {
        for (Type type : tree.symbol().interfaces()) {
            if (!type.is("java.lang.Comparable")) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsInt(MethodTree tree) {
        TypeTree typeTree = tree.returnType();
        return typeTree != null && typeTree.symbolType().isPrimitive(Type.Primitives.INT);
    }
}

