/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.LineUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2147")
public class CombineCatchCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ArrayDeque<CatchTree> catches = new ArrayDeque<CatchTree>();
        for (CatchTree catchTree : ((TryStatementTree)tree).catches()) {
            for (CatchTree catchTreeToBeCompared : catches) {
                if (!SyntacticEquivalence.areSemanticallyEquivalent((List)catchTree.block().body(), (List)catchTreeToBeCompared.block().body())) continue;
                this.reportIssueWithQuickFix(catchTree, catchTreeToBeCompared);
                break;
            }
            catches.push(catchTree);
        }
    }

    private void reportIssueWithQuickFix(CatchTree catchTree, CatchTree catchTreeToBeCompared) {
        String quickFixMessage = "Combine this catch with the one at line " + LineUtils.startLine((SyntaxToken)catchTreeToBeCompared.catchKeyword());
        String issueMessage = quickFixMessage + ", which has the same body." + this.context.getJavaVersion().java7CompatibilityMessage();
        List<JavaFileScannerContext.Location> flow = Collections.singletonList(new JavaFileScannerContext.Location("Combine with this catch", (Tree)catchTreeToBeCompared));
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)catchTree.parameter()).withMessage(issueMessage).withSecondaries(flow).withQuickFix(() -> this.computeQuickFix(catchTree, catchTreeToBeCompared, quickFixMessage)).report();
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    private JavaQuickFix computeQuickFix(CatchTree catchTree, CatchTree catchTreeToBeCompared, String qfMessage) {
        List<TypeTree> upperCatchTypes = CombineCatchCheck.getExceptionTypesCaught(catchTreeToBeCompared);
        List<TypeTree> lowerCatchTypes = CombineCatchCheck.getExceptionTypesCaught(catchTree);
        List<TypeTree> mergedTypes = CombineCatchCheck.mergeCatchTypes(upperCatchTypes, lowerCatchTypes);
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)qfMessage);
        builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)catchTree)});
        String replacement = this.computeReplacementString(mergedTypes, catchTreeToBeCompared);
        builder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceBetweenTree((Tree)catchTreeToBeCompared.openParenToken(), (boolean)false, (Tree)catchTreeToBeCompared.closeParenToken(), (boolean)false, (String)replacement)});
        return builder.build();
    }

    private String computeReplacementString(Collection<TypeTree> types, CatchTree toReplaceCatch) {
        StringBuilder sb = new StringBuilder();
        types.forEach(type -> sb.append(this.formatType((TypeTree)type) + " | "));
        sb.delete(sb.lastIndexOf("| "), sb.length());
        sb.append(toReplaceCatch.parameter().simpleName().name());
        return sb.toString();
    }

    private static List<TypeTree> mergeCatchTypes(List<TypeTree> upperCatchTypes, List<TypeTree> lowerCatchTypes) {
        ArrayList<TypeTree> result = new ArrayList<TypeTree>();
        for (TypeTree upperType : upperCatchTypes) {
            if (!CombineCatchCheck.isNotMaskedBySuperType(upperType, lowerCatchTypes)) continue;
            result.add(upperType);
        }
        result.addAll(lowerCatchTypes);
        return result;
    }

    private static boolean isNotMaskedBySuperType(TypeTree type, List<TypeTree> types) {
        for (TypeTree other : types) {
            if (!type.symbolType().isSubtypeOf(other.symbolType())) continue;
            return false;
        }
        return true;
    }

    private String formatType(TypeTree type) {
        if (type instanceof MemberSelectExpressionTreeImpl) {
            MemberSelectExpressionTreeImpl mtype = (MemberSelectExpressionTreeImpl)type;
            return QuickFixHelper.contentForTree((Tree)mtype, this.context);
        }
        return type.toString();
    }

    private static List<TypeTree> getExceptionTypesCaught(CatchTree catchTree) {
        TypeTree catchType = catchTree.parameter().type();
        if (catchType instanceof JavaTree.UnionTypeTreeImpl) {
            JavaTree.UnionTypeTreeImpl unionTypes = (JavaTree.UnionTypeTreeImpl)catchType;
            unionTypes.symbolType();
            return unionTypes.typeAlternatives();
        }
        return List.of(catchType);
    }
}

