/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1066")
public class CollapsibleIfCandidateCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<IfStatementTree> outerIf = new ArrayDeque<IfStatementTree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
        this.outerIf.clear();
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.outerIf.isEmpty() && !CollapsibleIfCandidateCheck.hasElseClause(tree)) {
            IfStatementTree outerIfStatement = this.outerIf.peek();
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.ifKeyword()).withMessage("Merge this if statement with the enclosing one.").withSecondaries(Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)outerIfStatement.ifKeyword()))).withQuickFix(() -> CollapsibleIfCandidateCheck.computeQuickFix(tree, outerIfStatement)).report();
        }
        if (!CollapsibleIfCandidateCheck.hasElseClause(tree) && CollapsibleIfCandidateCheck.hasBodySingleIfStatement(tree.thenStatement())) {
            this.outerIf.push(tree);
            super.visitIfStatement(tree);
            if (!this.outerIf.isEmpty()) {
                this.outerIf.pop();
            }
        } else {
            this.outerIf.clear();
            super.visitIfStatement(tree);
        }
    }

    private static boolean hasElseClause(IfStatementTree tree) {
        return tree.elseStatement() != null;
    }

    private static boolean hasBodySingleIfStatement(StatementTree thenStatement) {
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)thenStatement;
            return block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
        }
        return thenStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
    }

    private static JavaQuickFix computeQuickFix(IfStatementTree ifStatement, IfStatementTree outerIf) {
        JavaQuickFix.Builder quickFixBuilder = JavaQuickFix.newQuickFix((String)"Merge this if statement with the enclosing one");
        StatementTree containingStatement = outerIf.thenStatement();
        if (containingStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            StatementTree thenStatement = ifStatement.thenStatement();
            if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                SyntaxToken closingBrace = ((BlockTree)thenStatement).closeBraceToken();
                quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)closingBrace)});
            } else {
                quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)ifStatement.thenStatement(), (String)"{")});
            }
        }
        quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertAfterTree((Tree)ifStatement.closeParenToken(), (String)")")});
        quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceBetweenTree((Tree)outerIf.closeParenToken(), (Tree)ifStatement.ifKeyword(), (String)" && ")});
        return quickFixBuilder.build();
    }
}

