/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.YieldStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="AssignmentInSubExpressionCheck", repositoryKey="squid")
@Rule(key="S1121")
public class AssignmentInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Tree.Kind[] ASSIGNMENT_EXPRESSIONS = new Tree.Kind[]{Tree.Kind.AND_ASSIGNMENT, Tree.Kind.ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT};
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan((Tree)annotationTree.annotationType());
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (!lambdaExpressionTree.body().is(ASSIGNMENT_EXPRESSIONS)) {
            super.visitLambdaExpression(lambdaExpressionTree);
        }
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses((ExpressionTree)tree.expression());
        expressionTree = this.skipChainedAssignments(expressionTree);
        this.scan((Tree)expressionTree);
    }

    private ExpressionTree skipChainedAssignments(ExpressionTree expressionTree) {
        ExpressionTree tree = ExpressionUtils.skipParentheses((ExpressionTree)expressionTree);
        while (tree instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)tree;
            this.scan((Tree)assignmentExpressionTree.variable());
            tree = ExpressionUtils.skipParentheses((ExpressionTree)assignmentExpressionTree.expression());
        }
        return tree;
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (AssignmentInSubExpressionCheck.isRelationalExpression((Tree)tree)) {
            this.visitInnerExpression(tree.leftOperand());
            this.visitInnerExpression(tree.rightOperand());
        } else {
            super.visitBinaryExpression(tree);
        }
    }

    private void visitInnerExpression(ExpressionTree tree) {
        AssignmentExpressionTree assignmentExpressionTree = AssignmentInSubExpressionCheck.getInnerAssignmentExpression(tree);
        if (assignmentExpressionTree != null) {
            super.visitAssignmentExpression(assignmentExpressionTree);
        } else {
            this.scan((Tree)tree);
        }
    }

    @Nullable
    private static AssignmentExpressionTree getInnerAssignmentExpression(ExpressionTree tree) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return (AssignmentExpressionTree)expressionTree;
        }
        return null;
    }

    private static boolean isRelationalExpression(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO});
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitVariable(VariableTree tree) {
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            ExpressionTree expressionTree = this.skipChainedAssignments(initializer);
            this.scan((Tree)expressionTree);
        }
    }

    public void visitYieldStatement(YieldStatementTree tree) {
        if (AssignmentInSubExpressionCheck.isWithinSwitchExpression(tree)) {
            super.visitYieldStatement(tree);
        }
    }

    private static boolean isWithinSwitchExpression(YieldStatementTree tree) {
        Tree parent = tree.parent();
        while (!parent.is(new Tree.Kind[]{Tree.Kind.SWITCH_EXPRESSION, Tree.Kind.SWITCH_STATEMENT})) {
            parent = parent.parent();
        }
        return parent.is(new Tree.Kind[]{Tree.Kind.SWITCH_EXPRESSION});
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.context.reportIssue((JavaCheck)this, (Tree)tree.operatorToken(), "Extract the assignment out of this expression.");
    }
}

