/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.tests.AssertJChainSimplificationHelper;
import org.sonar.java.checks.tests.AssertJChainSimplificationIndex;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5838")
public class AssertJChainSimplificationCheck
extends AbstractMethodDetection {
    private static final String ISSUE_MESSAGE_FORMAT_STRING = "Use %s instead.";
    private static final MethodMatchers ASSERTION_MESSAGE_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"as", "describedAs", "withFailMessage", "overridingErrorMessage"}).withAnyParameters().build();
    private static final MethodMatchers ASSERTIONS_SUBJECT_METHODS = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForInterfaceTypes", "org.assertj.core.api.AssertionsForClassTypes"}).names(new String[]{"assertThat", "assertThatObject"}).addParametersMatcher(new String[]{"*"}).build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return ASSERTIONS_SUBJECT_METHODS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree subjectMit) {
        ArrayList<MethodInvocationTree> predicates = new ArrayList<MethodInvocationTree>();
        Optional<MethodInvocationTree> nextPredicateOpt = MethodTreeUtils.consecutiveMethodInvocation((Tree)subjectMit);
        while (nextPredicateOpt.isPresent()) {
            MethodInvocationTree nextPredicate = nextPredicateOpt.get();
            if (!ASSERTION_MESSAGE_METHODS.matches(nextPredicate)) {
                predicates.add(nextPredicate);
            }
            nextPredicateOpt = MethodTreeUtils.consecutiveMethodInvocation((Tree)nextPredicate);
        }
        boolean wasIssueRaised = AssertJChainSimplificationCheck.checkPredicatesForSimplification(predicates, AssertJChainSimplificationIndex.CONTEXT_FREE_SIMPLIFIERS, SimplifierWithoutContext::simplify, (predicate, replacement) -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)predicate), String.format(ISSUE_MESSAGE_FORMAT_STRING, replacement)));
        if (wasIssueRaised || predicates.size() > 1) {
            return;
        }
        AssertJChainSimplificationCheck.checkPredicatesForSimplification(predicates, AssertJChainSimplificationIndex.SIMPLIFIERS_WITH_CONTEXT, (simplifier, predicate) -> simplifier.simplify(subjectMit, (MethodInvocationTree)predicate), (predicate, replacement) -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)predicate), String.format(ISSUE_MESSAGE_FORMAT_STRING, replacement), Collections.singletonList(new JavaFileScannerContext.Location("This can be simplified", (Tree)subjectMit.arguments().get(0))), null));
    }

    private static <T> boolean checkPredicatesForSimplification(List<MethodInvocationTree> predicates, Map<String, List<T>> simplifiers, BiFunction<T, MethodInvocationTree, Optional<String>> simplificationMethod, BiConsumer<MethodInvocationTree, String> reportingMethod) {
        AssertJChainSimplificationHelper.BooleanFlag issueRaised = new AssertJChainSimplificationHelper.BooleanFlag();
        predicates.forEach(predicate -> {
            String predicateName = ExpressionUtils.methodName((MethodInvocationTree)predicate).name();
            if (simplifiers.containsKey(predicateName)) {
                ((List)simplifiers.get(predicateName)).stream().map(simplifier -> (Optional)simplificationMethod.apply((Object)simplifier, (MethodInvocationTree)predicate)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(replacement -> {
                    reportingMethod.accept((MethodInvocationTree)predicate, (String)replacement);
                    issueRaised.setTrue();
                });
            }
        });
        return issueRaised.value();
    }

    static interface SimplifierWithContext {
        public Optional<String> simplify(MethodInvocationTree var1, MethodInvocationTree var2);
    }

    static interface SimplifierWithoutContext {
        public Optional<String> simplify(MethodInvocationTree var1);
    }
}

