/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5443")
public class PubliclyWritableDirectoriesCheck
extends IssuableSubscriptionVisitor {
    private static final String STRING_TYPE = "java.lang.String";
    private static final String JAVA_NIO_FILE_FILES = "java.nio.file.Files";
    private static final String JAVA_NIO_FILE_PATHS = "java.nio.file.Paths";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String MESSAGE = "Make sure publicly writable directories are used safely here.";
    private static final List<String> PUBLIC_WRITABLE_DIRS = Arrays.asList("/tmp", "/var/tmp", "/usr/tmp", "/dev/shm", "/dev/mqueue", "/run/lock", "/var/run/lock", "/Library/Caches", "/Users/Shared", "/private/tmp", "/private/var/tmp", "\\\\Windows\\\\Temp", "\\\\Temp", "\\\\TMP");
    private static final Set<String> TMP_DIR_ENV = SetUtils.immutableSetOf((Object[])new String[]{"TMP", "TMPDIR"});
    private static final MethodMatchers CREATE_FILE_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Paths", "java.nio.file.Path"}).names(new String[]{"get"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Path"}).names(new String[]{"of"}).withAnyParameters().build()});
    private static final MethodMatchers CREATE_FILE_CONSTRUCTOR_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.io.File", "java.io.FileReader"}).constructor().addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "java.nio.charset.Charset"}).build();
    private static final MethodMatchers TEMP_DIR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.io.File"}).names(new String[]{"createTempFile"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build();
    private static final MethodMatchers NIO_TEMP_DIR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Files"}).names(new String[]{"createTempDirectory"}).withAnyParameters().build();
    private static final MethodMatchers NIO_TEMP_FILE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.Files"}).names(new String[]{"createTempFile"}).withAnyParameters().build();
    private static final MethodMatchers MAP_GET = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private static final MethodMatchers SYSTEM_GETENV = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.System"}).names(new String[]{"getenv"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (PubliclyWritableDirectoriesCheck.createdInTempDir(mit) || PubliclyWritableDirectoriesCheck.hasSensitiveFileName(mit) || PubliclyWritableDirectoriesCheck.usesSystemTempDir(mit)) {
                this.reportIssue(tree, MESSAGE);
            }
        } else {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (CREATE_FILE_CONSTRUCTOR_MATCHERS.matches(newClassTree) && PubliclyWritableDirectoriesCheck.isSensitiveFileName((ExpressionTree)newClassTree.arguments().get(0))) {
                this.reportIssue(tree, MESSAGE);
            }
        }
    }

    private static boolean hasSensitiveFileName(MethodInvocationTree mit) {
        return CREATE_FILE_MATCHERS.matches(mit) && PubliclyWritableDirectoriesCheck.isSensitiveFileName((ExpressionTree)mit.arguments().get(0));
    }

    private static boolean usesSystemTempDir(MethodInvocationTree mit) {
        return MAP_GET.matches(mit) && PubliclyWritableDirectoriesCheck.hasTMPAsArgument(mit) && PubliclyWritableDirectoriesCheck.isInitializedWithSystemGetEnv(mit);
    }

    private static boolean hasTMPAsArgument(MethodInvocationTree mit) {
        return ((ExpressionTree)mit.arguments().get(0)).asConstant(String.class).map(TMP_DIR_ENV::contains).orElse(false);
    }

    private static boolean createdInTempDir(MethodInvocationTree mit) {
        return TEMP_DIR_MATCHER.matches(mit) || NIO_TEMP_DIR_MATCHER.matches(mit) && mit.arguments().size() == 1 || NIO_TEMP_FILE_MATCHER.matches(mit) && mit.arguments().size() == 2;
    }

    private static boolean isSensitiveFileName(ExpressionTree expressionTree) {
        return expressionTree.asConstant(String.class).filter(path -> PUBLIC_WRITABLE_DIRS.stream().anyMatch(path::startsWith)).isPresent();
    }

    private static boolean isInitializedWithSystemGetEnv(MethodInvocationTree mit) {
        return ExpressionsHelper.getInvokedSymbol(mit).filter(ExpressionsHelper::isNotReassigned).map(Symbol::declaration).filter(decl -> decl.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(VariableTree::initializer).map(ExpressionUtils::skipParentheses).filter(initializer -> initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).map(arg_0 -> ((MethodMatchers)SYSTEM_GETENV).matches(arg_0)).orElse(false);
    }
}

