/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractHashAlgorithmChecker;
import org.sonar.java.collections.SetUtils;

@Rule(key="S4790")
public class DataHashingCheck
extends AbstractHashAlgorithmChecker {
    private static final Set<String> DEPRECATED_HASH_CLASSES = SetUtils.immutableSetOf((Object[])new String[]{AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD5.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.NO_OP.classFqn, AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.STANDARD.classFqn});
    private static final String MESSAGE = "Make sure this weak hash algorithm is not used in a sensitive context here.";

    @Override
    protected Optional<String> getMessageForClass(String className) {
        return DEPRECATED_HASH_CLASSES.contains(className) ? Optional.of(MESSAGE) : Optional.empty();
    }

    @Override
    protected String getMessageForAlgorithm(String algorithmName) {
        return MESSAGE;
    }
}

