/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5842")
public class EmptyStringRepetitionCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Rework this part of the regex to not match the empty string.";

    @Override
    public void checkRegex(RegexParseResult regex, ExpressionTree methodInvocationOrAnnotation) {
        new Visitor().visit(regex);
    }

    private class Visitor
    extends RegexBaseVisitor {
        private Visitor() {
        }

        public void visitRepetition(RepetitionTree tree) {
            RegexTree element = tree.getElement();
            if (this.matchEmptyString(element)) {
                EmptyStringRepetitionCheck.this.reportIssue((RegexSyntaxElement)element, EmptyStringRepetitionCheck.MESSAGE, null, Collections.emptyList());
            }
        }

        private boolean matchEmptyString(RegexTree element) {
            switch (element.kind()) {
                case SEQUENCE: {
                    return ((SequenceTree)element).getItems().stream().allMatch(this::matchEmptyString);
                }
                case DISJUNCTION: {
                    return ((DisjunctionTree)element).getAlternatives().stream().anyMatch(this::matchEmptyString);
                }
                case REPETITION: {
                    return ((RepetitionTree)element).getQuantifier().getMinimumRepetitions() == 0;
                }
                case LOOK_AROUND: 
                case BOUNDARY: {
                    return true;
                }
            }
            if (element instanceof GroupTree) {
                RegexTree nestedElement = ((GroupTree)element).getElement();
                return nestedElement == null || this.matchEmptyString(nestedElement);
            }
            return false;
        }
    }
}

