/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1158")
public class ToStringUsingBoxingCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> PRIMITIVE_WRAPPERS = SetUtils.immutableSetOf((Object[])new String[]{"Byte", "Short", "Integer", "Long", "Float", "Double", "Character", "Boolean"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        String newlyCreatedClassName;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        String callingToStringOrCompareTo = ToStringUsingBoxingCheck.isCallingToStringOrCompareTo(mit.methodSelect());
        if (callingToStringOrCompareTo != null && PRIMITIVE_WRAPPERS.contains(newlyCreatedClassName = ToStringUsingBoxingCheck.getNewlyCreatedClassName(mit))) {
            this.reportIssue((Tree)((MemberSelectExpressionTree)mit.methodSelect()).expression(), "Call the static method " + newlyCreatedClassName + "." + callingToStringOrCompareTo + "(...) instead of instantiating a temporary object to perform this to string conversion.");
        }
    }

    private static String getNewlyCreatedClassName(MethodInvocationTree mit) {
        MemberSelectExpressionTree mset = (MemberSelectExpressionTree)mit.methodSelect();
        if (mset.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            TypeTree classId = ((NewClassTree)mset.expression()).identifier();
            if (classId.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)classId).name();
            }
            if (classId.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return ((MemberSelectExpressionTree)classId).identifier().name();
            }
        }
        return "";
    }

    @CheckForNull
    private static String isCallingToStringOrCompareTo(ExpressionTree methodSelect) {
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            String name = ((MemberSelectExpressionTree)methodSelect).identifier().name();
            if ("toString".equals(name)) {
                return name;
            }
            if ("compareTo".equals(name)) {
                return "compare";
            }
        }
        return null;
    }
}

