/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5164")
public class ThreadLocalCleanupCheck
extends IssuableSubscriptionVisitor {
    private static final String THREAD_LOCAL = "java.lang.ThreadLocal";
    private static final MethodMatchers THREADLOCAL_SET = MethodMatchers.create().ofTypes(new String[]{"java.lang.ThreadLocal"}).names(new String[]{"set"}).addParametersMatcher(new String[]{"*"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol clazz = ((ClassTree)tree).symbol();
            Type superClass = clazz.superClass();
            if (clazz.type().isSubtypeOf(THREAD_LOCAL) || superClass != null && superClass.isUnknown()) {
                return;
            }
            clazz.memberSymbols().stream().filter(Symbol::isVariableSymbol).filter(s -> s.isPrivate() && s.type().is(THREAD_LOCAL)).forEach(this::checkThreadLocalField);
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (THREADLOCAL_SET.matches(mit) && ((ExpressionTree)mit.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                this.reportIssue((Tree)mit, "Use \"remove()\" instead of \"set(null)\".");
            }
        }
    }

    private void checkThreadLocalField(Symbol field) {
        if (field.usages().stream().noneMatch(ThreadLocalCleanupCheck::usageIsRemove)) {
            this.reportIssue((Tree)((VariableTree)field.declaration()).simpleName(), "Call \"remove()\" on \"" + field.name() + "\".");
        }
    }

    private static boolean usageIsRemove(IdentifierTree usage) {
        return MethodTreeUtils.consecutiveMethodInvocation((Tree)usage).filter(mit -> ExpressionUtils.methodName((MethodInvocationTree)mit).name().equals("remove")).isPresent();
    }
}

