/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3252")
public class StaticMemberAccessCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers LIST_SET_OF = MethodMatchers.create().ofTypes(new String[]{"java.util.List", "java.util.Set"}).names(new String[]{"of"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
        Symbol symbol = mse.identifier().symbol();
        if (symbol.isStatic() && !StaticMemberAccessCheck.isListOrSetOf(mse)) {
            ExpressionTree expression = mse.expression();
            Type staticType = symbol.owner().type();
            if (!expression.symbolType().erasure().equals(staticType.erasure())) {
                this.reportIssue((Tree)mse.identifier(), String.format("Use static access with \"%s\" for \"%s\".", staticType.fullyQualifiedName(), symbol.name()));
            }
        }
    }

    private static boolean isListOrSetOf(MemberSelectExpressionTree mse) {
        Tree parent = mse.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && LIST_SET_OF.matches((MethodInvocationTree)parent);
    }
}

