/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JWarning;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1905")
public class RedundantTypeCastCheck
extends IssuableSubscriptionVisitor {
    private List<JWarning> warnings;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.warnings = ((JavaTree.CompilationUnitTreeImpl)tree).warnings(JWarning.Type.REDUNDANT_CAST);
            return;
        }
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        Type cast = typeCastTree.type().symbolType();
        if (this.isUnnecessaryCast(typeCastTree)) {
            this.reportIssue((Tree)typeCastTree.type(), "Remove this unnecessary cast to \"" + cast.erasure() + "\".");
        }
    }

    public static Tree skipParentheses(Tree tree) {
        if (tree instanceof ExpressionTree) {
            return ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)tree));
        }
        return tree;
    }

    private boolean isUnnecessaryCast(TypeCastTree typeCastTree) {
        if (RedundantTypeCastCheck.skipParentheses((Tree)typeCastTree.expression()).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            Tree parentTree = RedundantTypeCastCheck.skipParentheses(typeCastTree.parent());
            return !parentTree.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS});
        }
        return this.warnings.stream().anyMatch(warning -> RedundantTypeCastCheck.matchesWarning(warning, typeCastTree));
    }

    private static boolean matchesWarning(JWarning warning, TypeCastTree tree) {
        Tree warningTree = warning.syntaxTree();
        if (warningTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return tree.equals(RedundantTypeCastCheck.skipParentheses(warningTree));
        }
        return tree.equals(warningTree);
    }
}

