/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4454")
public class EqualsParametersMarkedNonNullCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        VariableTree variable;
        MethodTree methodTree = (MethodTree)tree;
        List params = methodTree.parameters();
        if ("equals".equals(methodTree.symbol().name()) && params.size() == 1 && (variable = (VariableTree)params.get(0)).type().symbolType().is("java.lang.Object") && NullableAnnotationUtils.isAnnotatedNonNull((Symbol)variable.symbol())) {
            this.reportIssue((Tree)variable, "\"equals\" method parameters should not be marked \"@Nonnull\".");
        }
    }
}

