/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.CompareWithEqualsVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S4973")
public class CompareStringsBoxedTypesWithEqualsCheck
extends CompareWithEqualsVisitor {
    @Override
    protected void checkEqualityExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        Type leftOpType = tree.leftOperand().symbolType();
        if (!CompareStringsBoxedTypesWithEqualsCheck.isNullComparison(leftOpType, rightOpType = tree.rightOperand().symbolType()) && !CompareStringsBoxedTypesWithEqualsCheck.isCompareWithBooleanConstant(tree.leftOperand(), tree.rightOperand()) && (CompareStringsBoxedTypesWithEqualsCheck.isStringType(leftOpType, rightOpType) || CompareStringsBoxedTypesWithEqualsCheck.isBoxedType(leftOpType, rightOpType))) {
            this.reportIssue(tree.operatorToken());
        }
    }

    private static boolean isCompareWithBooleanConstant(ExpressionTree left, ExpressionTree right) {
        return ExpressionsHelper.getConstantValueAsBoolean(left).value() != null || ExpressionsHelper.getConstantValueAsBoolean(right).value() != null;
    }
}

