/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractHashAlgorithmChecker;

@Rule(key="S4790")
public class DataHashingCheck
extends AbstractHashAlgorithmChecker {
    public static final Set<String> DEPRECATED_HASH_CLASSES = ImmutableSet.of((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD5.classFqn, (Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.classFqn, (Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.classFqn, (Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.classFqn, (Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.classFqn, (Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.NO_OP.classFqn, (Object[])new String[]{AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.STANDARD.classFqn});
    private static final String MESSAGE = "Make sure this weak hash algorithm is not used in a sensitive context here.";

    @Override
    protected Optional<String> getMessageForClass(String className) {
        return DEPRECATED_HASH_CLASSES.contains(className) ? Optional.of(MESSAGE) : Optional.empty();
    }

    @Override
    protected String getMessageForAlgorithm(String algorithmName) {
        return MESSAGE;
    }
}

