/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.AtomicGroupTree;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5852")
public class RedosCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Make sure the regex used in this method call cannot lead to denial of service.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        NestedRepetitionsFinder visitor = new NestedRepetitionsFinder();
        visitor.visit(regexForLiterals);
        if (visitor.containsOffendingRepetitions) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), MESSAGE, null, Collections.emptyList());
        }
    }

    private static class NestedRepetitionsFinder
    extends RegexBaseVisitor {
        private boolean isInsideRepetition = false;
        private boolean containsOffendingRepetitions = false;

        private NestedRepetitionsFinder() {
        }

        public void visitRepetition(RepetitionTree tree) {
            boolean isPotentiallyProblematic;
            boolean bl = isPotentiallyProblematic = tree.getQuantifier().isOpenEnded() && tree.getQuantifier().getModifier() != Quantifier.Modifier.POSSESSIVE;
            if (isPotentiallyProblematic) {
                if (this.isInsideRepetition) {
                    this.containsOffendingRepetitions = true;
                    return;
                }
                this.isInsideRepetition = true;
            }
            super.visitRepetition(tree);
            if (isPotentiallyProblematic) {
                this.isInsideRepetition = false;
            }
        }

        public void visitAtomicGroup(AtomicGroupTree tree) {
            boolean oldIsInsideRepetition = this.isInsideRepetition;
            this.isInsideRepetition = false;
            super.visitAtomicGroup(tree);
            this.isInsideRepetition = oldIsInsideRepetition;
        }
    }
}

