/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterClassUnionTree;
import org.sonar.java.regex.ast.CharacterRangeTree;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S5869")
public class DuplicatesInCharacterClassCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Remove duplicates in this character class.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        new DuplicateFinder().visit(regexForLiterals);
    }

    private class DuplicateFinder
    extends RegexBaseVisitor {
        private DuplicateFinder() {
        }

        public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
            ArrayList<RegexTree> duplicates = new ArrayList<RegexTree>();
            TreeMap<Integer, Boolean> inCharacterClass = new TreeMap<Integer, Boolean>();
            for (RegexTree element : tree.getCharacterClasses()) {
                if (element.is(new RegexTree.Kind[]{RegexTree.Kind.PLAIN_CHARACTER, RegexTree.Kind.UNICODE_CODE_POINT})) {
                    int ch = ((CharacterTree)element).codePointOrUnit();
                    this.processRange(duplicates, inCharacterClass, ch, ch, element);
                    continue;
                }
                if (!element.is(new RegexTree.Kind[]{RegexTree.Kind.CHARACTER_RANGE})) continue;
                CharacterRangeTree range = (CharacterRangeTree)element;
                int lower = range.getLowerBound().codePointOrUnit();
                int upper = range.getUpperBound().codePointOrUnit();
                this.processRange(duplicates, inCharacterClass, lower, upper, (RegexTree)range);
            }
            if (!duplicates.isEmpty()) {
                List<RegexCheck.RegexIssueLocation> secondaries = duplicates.stream().skip(1L).map(duplicate -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)duplicate, "Additional duplicate")).collect(Collectors.toList());
                DuplicatesInCharacterClassCheck.this.reportIssue((RegexSyntaxElement)duplicates.get(0), DuplicatesInCharacterClassCheck.MESSAGE, null, secondaries);
            }
            super.visitCharacterClassUnion(tree);
        }

        void processRange(List<RegexTree> duplicates, TreeMap<Integer, Boolean> inCharacterClass, int from, int to, RegexTree tree) {
            if (to < from) {
                return;
            }
            if (this.containsOverlap(inCharacterClass, from = this.caseFold(from), to = this.caseFold(to))) {
                duplicates.add(tree);
            }
            inCharacterClass.put(from, true);
            for (Map.Entry entry : inCharacterClass.subMap(from, true, to, true).entrySet()) {
                entry.setValue(true);
            }
            int next = to + 1;
            if (!inCharacterClass.containsKey(next)) {
                inCharacterClass.put(next, false);
            }
        }

        boolean containsOverlap(TreeMap<Integer, Boolean> inCharacterClass, int from, int to) {
            Map.Entry<Integer, Boolean> fromEntry = inCharacterClass.floorEntry(from);
            Map.Entry<Integer, Boolean> toEntry = inCharacterClass.floorEntry(to);
            return fromEntry != null && fromEntry.getValue() != false || !Objects.equals(fromEntry, toEntry);
        }

        int caseFold(int ch) {
            if (this.flagActive(2) && (this.flagActive(64) || 65 <= ch && ch <= 90)) {
                return Character.toLowerCase(Character.toUpperCase(ch));
            }
            return ch;
        }
    }
}

