/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2047")
public class BooleanMethodNameCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        IdentifierTree simpleName = methodTree.simpleName();
        if (BooleanMethodNameCheck.returnsBoolean(methodTree) && BooleanMethodNameCheck.isBooleanGetter(simpleName) && BooleanMethodNameCheck.isNotOverriding(methodTree)) {
            this.reportIssue((Tree)simpleName, "Rename this method to start with \"is\" or \"has\".");
        }
    }

    private static boolean isBooleanGetter(IdentifierTree simpleName) {
        String text = simpleName.identifierToken().text();
        return text.startsWith("get") && !text.startsWith("getBoolean");
    }

    private static boolean isNotOverriding(MethodTree methodTree) {
        return Boolean.FALSE.equals(methodTree.isOverriding());
    }

    private static boolean returnsBoolean(MethodTree methodTree) {
        return methodTree.returnType().symbolType().isPrimitive(Type.Primitives.BOOLEAN);
    }
}

