/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2123")
public class UselessIncrementCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.RETURN_STATEMENT, Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            UnaryExpressionTree unaryExpression;
            ExpressionTree expression;
            ExpressionTree returnExpression = ((ReturnStatementTree)tree).expression();
            if (returnExpression != null && UselessIncrementCheck.isPostfix(returnExpression) && (expression = ExpressionUtils.skipParentheses((ExpressionTree)(unaryExpression = (UnaryExpressionTree)returnExpression).expression())).is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)expression).symbol().owner().isMethodSymbol()) {
                this.reportIssue(unaryExpression);
            }
        } else {
            AssignmentExpressionTree aet = (AssignmentExpressionTree)tree;
            if (UselessIncrementCheck.isPostfix(aet.expression())) {
                UnaryExpressionTree postfix = (UnaryExpressionTree)aet.expression();
                if (SyntacticEquivalence.areEquivalent((Tree)aet.variable(), (Tree)postfix.expression())) {
                    this.reportIssue(postfix);
                }
            }
        }
    }

    private void reportIssue(UnaryExpressionTree expression) {
        this.reportIssue((Tree)expression.operatorToken(), "Remove this increment or correct the code not to waste it.");
    }

    private static boolean isPostfix(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT});
    }
}

