/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2162")
public class SymmetricEqualsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree;
        if (this.hasSemantic() && MethodTreeUtils.isEqualsMethod(methodTree = (MethodTree)tree) && methodTree.block() != null) {
            methodTree.block().accept((TreeVisitor)new SymmetryBrokePatterns(methodTree.symbol()));
        }
    }

    private class SymmetryBrokePatterns
    extends BaseTreeVisitor {
        private final Symbol.MethodSymbol methodSymbol;
        private final Symbol owner;

        public SymmetryBrokePatterns(Symbol.MethodSymbol methodSymbol) {
            this.methodSymbol = methodSymbol;
            this.owner = methodSymbol.owner();
        }

        private boolean isOwnerFinal() {
            return this.owner.isFinal();
        }

        public void visitInstanceOf(InstanceOfTree tree) {
            if (tree.type().symbolType().erasure().equals(this.owner.type().erasure())) {
                if (!this.isOwnerFinal() && !this.methodSymbol.isFinal()) {
                    SymmetricEqualsCheck.this.reportIssue((Tree)tree, "Compare to \"this.getClass()\" instead.");
                }
            } else {
                SymmetricEqualsCheck.this.reportIssue((Tree)tree, "Remove this comparison to an unrelated class.");
            }
            super.visitInstanceOf(tree);
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
                this.checkOperand(tree.leftOperand());
                this.checkOperand(tree.rightOperand());
            }
            super.visitBinaryExpression(tree);
        }

        private void checkOperand(ExpressionTree expressionTree) {
            MemberSelectExpressionTree mset;
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isClassExpression(mset = (MemberSelectExpressionTree)expressionTree)) {
                if (this.isClassOfOwner(mset)) {
                    if (!this.isOwnerFinal()) {
                        SymmetricEqualsCheck.this.reportIssue((Tree)expressionTree, "Compare to \"this.getClass()\" instead.");
                    }
                } else {
                    SymmetricEqualsCheck.this.reportIssue((Tree)expressionTree, "Remove this comparison to an unrelated class.");
                }
            }
        }

        private boolean isClassExpression(MemberSelectExpressionTree mset) {
            return JavaKeyword.CLASS.getValue().equals(mset.identifier().name());
        }

        private boolean isClassOfOwner(MemberSelectExpressionTree mset) {
            return mset.expression().symbolType().equals(this.owner.type());
        }
    }
}

