/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2196")
public class SwitchInsteadOfIfSequenceCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree parentIf;
        if (tree.parent().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && tree.equals((parentIf = (IfStatementTree)tree.parent()).elseStatement())) {
            return;
        }
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        int level = 1;
        while (ifStatementTree.elseKeyword() != null && ifStatementTree.elseStatement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            ++level;
            if (!SwitchInsteadOfIfSequenceCheck.sameEqualCondition(ifStatementTree.condition(), ((IfStatementTree)ifStatementTree.elseStatement()).condition())) {
                level = 0;
                break;
            }
            ifStatementTree = (IfStatementTree)ifStatementTree.elseStatement();
        }
        if (level > 2) {
            this.reportIssue((Tree)((IfStatementTree)tree).condition(), "Convert this \"if/else if\" structure into a \"switch\"." + this.context.getJavaVersion().java7CompatibilityMessage());
        }
    }

    private static boolean sameEqualCondition(ExpressionTree firstIfCondition, ExpressionTree secondIfCondition) {
        Optional<EqualsOperands> equalsOperandsFirst = SwitchInsteadOfIfSequenceCheck.getEqualMethodInvocationOperands(firstIfCondition);
        Optional<EqualsOperands> equalsOperandsSecond = SwitchInsteadOfIfSequenceCheck.getEqualMethodInvocationOperands(secondIfCondition);
        return equalsOperandsFirst.isPresent() && equalsOperandsSecond.isPresent() && equalsOperandsFirst.get().identifier.symbol().equals(equalsOperandsSecond.get().identifier.symbol());
    }

    private static Optional<EqualsOperands> getEqualMethodInvocationOperands(ExpressionTree expressionTree) {
        ExpressionTree arg = null;
        ExpressionTree expression = null;
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expressionTree;
            Symbol symbol = mit.symbol();
            ExpressionTree methodSelect = mit.methodSelect();
            if (mit.arguments().size() == 1) {
                arg = (ExpressionTree)mit.arguments().get(0);
                if ("equals".equals(symbol.name()) && arg.symbolType().is("java.lang.String") && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    expression = ((MemberSelectExpressionTree)methodSelect).expression();
                }
            }
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            BinaryExpressionTree equalTo = (BinaryExpressionTree)expressionTree;
            arg = equalTo.leftOperand();
            expression = equalTo.rightOperand();
        }
        if (arg != null && expression != null) {
            if (arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return Optional.of(new EqualsOperands((LiteralTree)arg, (IdentifierTree)expression));
            }
            if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                return Optional.of(new EqualsOperands((LiteralTree)expression, (IdentifierTree)arg));
            }
        }
        return Optional.empty();
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    private static class EqualsOperands {
        LiteralTree literal;
        IdentifierTree identifier;

        EqualsOperands(LiteralTree literal, IdentifierTree identifier) {
            this.literal = literal;
            this.identifier = identifier;
        }
    }
}

