/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4288")
public class SpringConstructorInjectionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        List toReport;
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (SpringConstructorInjectionCheck.isClassTreeAnnotatedWith(classTree, "org.springframework.stereotype.Controller", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Service") && !(toReport = classTree.members().stream().filter(SpringConstructorInjectionCheck::isMemberAutowired).map(SpringConstructorInjectionCheck::toReportTree).collect(Collectors.toList())).isEmpty()) {
            int cost = toReport.size();
            classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(m -> ((MethodTree)m).simpleName()).findFirst().ifPresent(toReport::add);
            this.reportIssue((Tree)toReport.get(0), "Remove this annotation and use constructor injection instead.", toReport.stream().skip(1L).map(i -> new JavaFileScannerContext.Location("", i)).collect(Collectors.toList()), cost);
        }
    }

    private static boolean isMemberAutowired(Tree member) {
        Symbol s = null;
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            s = ((VariableTree)member).symbol();
        } else if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            s = ((MethodTree)member).symbol();
        }
        return s != null && !s.isStatic() && SpringConstructorInjectionCheck.isAutowired(s);
    }

    private static boolean isAutowired(Symbol s) {
        return s.metadata().isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired");
    }

    private static Tree toReportTree(Tree member) {
        Stream<Object> stream = Stream.empty();
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            stream = ((VariableTree)member).modifiers().annotations().stream();
        } else if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            stream = ((MethodTree)member).modifiers().annotations().stream();
        }
        return (Tree)stream.filter(a -> a.annotationType().symbolType().is("org.springframework.beans.factory.annotation.Autowired")).findFirst().orElseThrow(() -> new IllegalStateException("Mapping a tree to something unexpected"));
    }

    private static boolean isClassTreeAnnotatedWith(ClassTree classTree, String ... annotationName) {
        return Arrays.stream(annotationName).anyMatch(annotation -> classTree.symbol().metadata().isAnnotatedWith(annotation));
    }
}

