/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4682")
public final class PrimitivesMarkedNullableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        TypeTree returnType = methodTree.returnType();
        if (returnType.symbolType().isPrimitive()) {
            NullableAnnotationUtils.nullableAnnotation((ModifiersTree)methodTree.modifiers()).map(annotation -> annotation.annotationType().symbolType().name()).ifPresent(annotation -> this.reportIssue((Tree)returnType, String.format("\"@%s\" annotation should not be used on primitive types", annotation)));
        }
    }
}

