/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1226")
public class ParameterReassignedToCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Set<Symbol> variables = new HashSet<Symbol>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.variables.clear();
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        BlockTree block = tree.block();
        if (block == null) {
            return;
        }
        CFG cfg = CFG.build((MethodTree)tree);
        LiveVariables analyze = LiveVariables.analyze((CFG)cfg);
        Set live = analyze.getIn(cfg.entryBlock());
        for (VariableTree parameterTree : tree.parameters()) {
            if (live.contains(parameterTree.symbol())) continue;
            this.variables.add(parameterTree.symbol());
        }
        super.visitMethod(tree);
        for (VariableTree parameterTree : tree.parameters()) {
            if (live.contains(parameterTree.symbol())) continue;
            this.variables.remove(parameterTree.symbol());
        }
    }

    public void visitCatch(CatchTree tree) {
        CFG cfg = CFG.buildCFG((List)tree.block().body(), (boolean)true);
        Symbol var = tree.parameter().symbol();
        boolean liveVar = true;
        if (var.owner().isMethodSymbol()) {
            cfg.setMethodSymbol((Symbol.MethodSymbol)var.owner());
            LiveVariables analyze = LiveVariables.analyze((CFG)cfg);
            Set live = analyze.getIn(cfg.entryBlock());
            liveVar = live.contains(var);
        }
        if (!liveVar) {
            this.variables.add(var);
        }
        super.visitCatch(tree);
        if (!liveVar) {
            this.variables.remove(var);
        }
    }

    public void visitForEachStatement(ForEachStatement tree) {
        CFG cfg = CFG.buildCFG(Collections.singletonList(tree), (boolean)true);
        Symbol var = tree.variable().symbol();
        boolean liveVar = true;
        if (var.owner().isMethodSymbol()) {
            cfg.setMethodSymbol((Symbol.MethodSymbol)var.owner());
            LiveVariables analyze = LiveVariables.analyze((CFG)cfg);
            Set live = analyze.getOut((CFG.Block)cfg.reversedBlocks().get(1));
            liveVar = live.contains(var);
        }
        if (!liveVar) {
            this.variables.add(var);
        }
        super.visitForEachStatement(tree);
        if (!liveVar) {
            this.variables.remove(var);
        }
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        IdentifierTree identifier;
        Symbol reference;
        ExpressionTree variable = tree.variable();
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = (identifier = (IdentifierTree)variable).symbol()).isVariableSymbol() && this.variables.contains(reference)) {
            this.context.reportIssue((JavaCheck)this, (Tree)identifier, "Introduce a new variable instead of reusing the parameter \"" + identifier.name() + "\".");
        }
    }
}

