/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1821")
public class NestedSwitchStatementCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        NestedSwitchVisitor visitor = new NestedSwitchVisitor();
        ((SwitchStatementTree)tree).cases().stream().forEach(c -> c.accept((TreeVisitor)visitor));
    }

    private class NestedSwitchVisitor
    extends BaseTreeVisitor {
        private NestedSwitchVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            NestedSwitchStatementCheck.this.reportIssue((Tree)tree.switchKeyword(), "Refactor the code to eliminate this nested \"switch\".");
        }
    }
}

