/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1199")
public class NestedBlocksCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCaseGroup(CaseGroupTree tree) {
        this.checkStatements(tree.body());
        super.visitCaseGroup(tree);
    }

    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.body());
        super.visitBlock(tree);
    }

    private void checkStatements(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) continue;
            this.context.reportIssue((JavaCheck)this, (Tree)((BlockTree)statement).openBraceToken(), "Extract this nested code block into a method.");
        }
    }
}

