/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2201")
public class IgnoredReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final List<String> CHECKED_TYPES = ImmutableList.builder().add((Object)"java.lang.String").add((Object)"java.lang.Boolean").add((Object)"java.lang.Integer").add((Object)"java.lang.Double").add((Object)"java.lang.Float").add((Object)"java.lang.Byte").add((Object)"java.lang.Character").add((Object)"java.lang.Short").add((Object)"java.lang.StackTraceElement").add((Object)"java.time.DayOfWeek").add((Object)"java.time.Duration").add((Object)"java.time.Instant").add((Object)"java.time.LocalDate").add((Object)"java.time.LocalDateTime").add((Object)"java.time.LocalTime").add((Object)"java.time.Month").add((Object)"java.time.MonthDay").add((Object)"java.time.OffsetDateTime").add((Object)"java.time.OffsetTime").add((Object)"java.time.Period").add((Object)"java.time.Year").add((Object)"java.time.YearMonth").add((Object)"java.time.ZonedDateTime").add((Object)"java.math.BigInteger").add((Object)"java.math.BigDecimal").add((Object)"java.util.Optional").add((Object)"com.google.common.base.Optional").build();
    private static final Set<String> EXCLUDED_PREFIX = ImmutableSet.of((Object)"parse", (Object)"format", (Object)"decode", (Object)"valueOf");
    private static final MethodMatchers EXCLUDED = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Character"}).names(new String[]{"toChars"}).addParametersMatcher(new String[]{"int", "char[]", "int"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"intern"}).addWithoutParametersMatcher().build()});
    private static final MethodMatchers STRING_GET_BYTES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes"}).addParametersMatcher(new String[]{"java.nio.charset.Charset"}).build();
    private static final MethodMatchers COLLECTION_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"size", "isEmpty", "contains", "containsAll", "iterator"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"toArray"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"get", "getOrDefault", "size", "isEmpty", "containsKey", "containsValue", "keySet", "entrySet", "values"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree expr = ((ExpressionStatementTree)tree).expression();
        if (expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expr;
            if (IgnoredReturnValueCheck.isExcluded(mit)) {
                return;
            }
            if (IgnoredReturnValueCheck.shouldUseReturnValue(mit)) {
                IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
                this.reportIssue((Tree)methodName, "The return value of \"" + methodName.name() + "\" must be used.");
            }
        }
    }

    private static boolean shouldUseReturnValue(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        return !IgnoredReturnValueCheck.isVoidOrUnknown(mit.symbolType()) && !IgnoredReturnValueCheck.isConstructor(symbol) && symbol.isPublic() && (IgnoredReturnValueCheck.isCheckedType(symbol.owner().type()) || COLLECTION_METHODS.matches(symbol));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcluded(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        if (mit.symbol().isUnknown()) return true;
        if (EXCLUDED.matches(mit)) return true;
        if (!IgnoredReturnValueCheck.isInTryCatch(mit)) return false;
        if (EXCLUDED_PREFIX.stream().anyMatch(methodName::startsWith)) return true;
        if (!STRING_GET_BYTES.matches(mit)) return false;
        return true;
    }

    private static boolean isInTryCatch(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}); parent = parent.parent()) {
        }
        return parent != null && !((TryStatementTree)parent).catches().isEmpty();
    }

    private static boolean isCheckedType(Type ownerType) {
        return CHECKED_TYPES.stream().anyMatch(arg_0 -> ((Type)ownerType).is(arg_0));
    }

    private static boolean isVoidOrUnknown(Type methodType) {
        return methodType.isVoid() || methodType.isUnknown();
    }

    private static boolean isConstructor(Symbol methodSymbol) {
        return "<init>".equals(methodSymbol.name());
    }
}

