/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1170")
public class ConstantsShouldBeStaticFinalCheck
extends IssuableSubscriptionVisitor {
    private int nestedClassesLevel;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void setContext(JavaFileScannerContext context) {
        this.nestedClassesLevel = 0;
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        ++this.nestedClassesLevel;
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTree variableTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !ConstantsShouldBeStaticFinalCheck.staticNonFinal(variableTree = (VariableTree)member) || !ConstantsShouldBeStaticFinalCheck.hasConstantInitializer(variableTree) || this.isObjectInInnerClass(variableTree)) continue;
            this.reportIssue((Tree)variableTree.simpleName(), "Make this final field static too.");
        }
    }

    private boolean isObjectInInnerClass(VariableTree variableTree) {
        if (this.nestedClassesLevel > 1) {
            ExpressionTree initializer = variableTree.initializer();
            return !variableTree.type().is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && !variableTree.symbol().type().is("java.lang.String") || initializer == null || !initializer.asConstant().isPresent();
        }
        return false;
    }

    private static boolean staticNonFinal(VariableTree variableTree) {
        return ConstantsShouldBeStaticFinalCheck.isFinal(variableTree) && !ConstantsShouldBeStaticFinalCheck.isStatic(variableTree);
    }

    public void leaveNode(Tree tree) {
        --this.nestedClassesLevel;
    }

    private static boolean hasConstantInitializer(VariableTree variableTree) {
        ExpressionTree init = variableTree.initializer();
        if (init != null) {
            MethodReferenceTree methodRef;
            if (ExpressionUtils.skipParentheses((ExpressionTree)init).is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) && ConstantsShouldBeStaticFinalCheck.isInstanceIdentifier((methodRef = (MethodReferenceTree)ExpressionUtils.skipParentheses((ExpressionTree)init)).expression())) {
                return false;
            }
            if (init.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
                return false;
            }
            return !ConstantsShouldBeStaticFinalCheck.containsChildrenOfKind((JavaTree)init, Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
        }
        return false;
    }

    private static boolean isInstanceIdentifier(Tree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !((IdentifierTree)expression).symbol().isStatic();
    }

    private static boolean containsChildrenOfKind(JavaTree tree, Tree.Kind ... kinds) {
        if (Arrays.asList(kinds).contains(tree.kind())) {
            return true;
        }
        if (!tree.isLeaf()) {
            for (Tree javaTree : tree.getChildren()) {
                if (javaTree == null || !ConstantsShouldBeStaticFinalCheck.containsChildrenOfKind((JavaTree)javaTree, kinds)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFinal(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC);
    }
}

