/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2701")
public class BooleanOrNullLiteralInAssertionsCheck
extends AbstractMethodDetection {
    private static final String DEFAULT_MESSAGE = "Remove or correct this assertion.";
    private static final String MESSAGE_WITH_ALTERNATIVE = "Use %s instead.";
    private static final String ASSERT = "assert";
    private static final String IS = "is";
    private static final MethodMatchers FEST_ASSERT_THAT = MethodMatchers.create().ofTypes(new String[]{"org.fest.assertions.Assertions"}).names(new String[]{"assertThat"}).addParametersMatcher(new String[]{"*"}).build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert", "org.junit.jupiter.api.Assertions", "junit.framework.Assert", "junit.framework.TestCase"}).name(name -> name.startsWith(ASSERT)).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert"}).name(name -> name.startsWith(IS)).withAnyParameters().build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        switch (mit.symbol().name()) {
            case "assertEquals": 
            case "assertSame": {
                this.checkEqualityAsserts(mit, false);
                break;
            }
            case "assertNotEquals": 
            case "assertNotSame": {
                this.checkEqualityAsserts(mit, true);
                break;
            }
            case "isEqualTo": 
            case "isSameAs": {
                this.checkFestEqualityAsserts(mit, false);
                break;
            }
            case "isNotEqualTo": 
            case "isNotSameAs": {
                this.checkFestEqualityAsserts(mit, true);
                break;
            }
            default: {
                this.checkOtherAsserts(mit);
            }
        }
    }

    private void checkEqualityAsserts(MethodInvocationTree mit, boolean flipped) {
        List<LiteralTree> literals = BooleanOrNullLiteralInAssertionsCheck.findLiterals((List<ExpressionTree>)mit.arguments());
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        if (literals.size() > 1) {
            this.reportDefaultMessage(methodName, literals);
        } else if (literals.size() == 1) {
            this.checkEqualityAssertWithOneLiteral(methodName, literals.get(0), flipped, ASSERT);
        }
    }

    private void checkFestEqualityAsserts(MethodInvocationTree mit, boolean flipped) {
        if (mit.arguments().isEmpty()) {
            return;
        }
        Optional<LiteralTree> expectedLiteral = BooleanOrNullLiteralInAssertionsCheck.getBoolOrNullLiteral((ExpressionTree)mit.arguments().get(0));
        Optional<LiteralTree> actualLiteral = BooleanOrNullLiteralInAssertionsCheck.findActualLiteralForFest(mit);
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        if (expectedLiteral.isPresent() && actualLiteral.isPresent()) {
            this.reportDefaultMessage(methodName, Arrays.asList(expectedLiteral.get(), actualLiteral.get()));
        } else {
            expectedLiteral.ifPresent(literal -> this.checkEqualityAssertWithOneLiteral(methodName, (LiteralTree)literal, flipped, IS));
            actualLiteral.ifPresent(literal -> this.checkEqualityAssertWithOneLiteral(methodName, (LiteralTree)literal, flipped, IS));
        }
    }

    private void checkEqualityAssertWithOneLiteral(IdentifierTree methodName, LiteralTree literal, boolean flipped, String assertOrIs) {
        String predicate;
        if (literal.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            predicate = flipped ? "NotNull" : "Null";
        } else {
            Optional value = literal.asConstant(Boolean.class);
            if (!value.isPresent()) {
                return;
            }
            predicate = Boolean.TRUE.equals(value.get()) ? (flipped ? "False" : "True") : (flipped ? "True" : "False");
        }
        String recommendedAssertMethod = assertOrIs + predicate;
        List<JavaFileScannerContext.Location> secondaryLocation = Collections.singletonList(new JavaFileScannerContext.Location("This literal can be avoided by using a different assertion method.", (Tree)literal));
        String mainMessage = String.format(MESSAGE_WITH_ALTERNATIVE, recommendedAssertMethod);
        this.reportIssue((Tree)methodName, mainMessage, secondaryLocation, null);
    }

    private void checkOtherAsserts(MethodInvocationTree mit) {
        List<LiteralTree> literals = BooleanOrNullLiteralInAssertionsCheck.findLiterals((List<ExpressionTree>)mit.arguments());
        Optional<LiteralTree> festActualLiteral = BooleanOrNullLiteralInAssertionsCheck.findActualLiteralForFest(mit);
        festActualLiteral.ifPresent(literals::add);
        if (!literals.isEmpty()) {
            this.reportDefaultMessage(ExpressionUtils.methodName((MethodInvocationTree)mit), literals);
        }
    }

    private static List<LiteralTree> findLiterals(List<ExpressionTree> expressions) {
        ArrayList<LiteralTree> result = new ArrayList<LiteralTree>();
        for (ExpressionTree expression : expressions) {
            BooleanOrNullLiteralInAssertionsCheck.getBoolOrNullLiteral(expression).ifPresent(result::add);
        }
        return result;
    }

    private static Optional<LiteralTree> findActualLiteralForFest(MethodInvocationTree mit) {
        if (FEST_ASSERT_THAT.matches(mit)) {
            return BooleanOrNullLiteralInAssertionsCheck.getBoolOrNullLiteral((ExpressionTree)mit.arguments().get(0));
        }
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree member = (MemberSelectExpressionTree)mit.methodSelect();
            if (member.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return BooleanOrNullLiteralInAssertionsCheck.findActualLiteralForFest((MethodInvocationTree)member.expression());
            }
        }
        return Optional.empty();
    }

    private static Optional<LiteralTree> getBoolOrNullLiteral(ExpressionTree expr) {
        if (expr.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            return BooleanOrNullLiteralInAssertionsCheck.getBoolOrNullLiteral(((TypeCastTree)expr).expression());
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || expr.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return Optional.of((LiteralTree)expr);
        }
        return Optional.empty();
    }

    private void reportDefaultMessage(IdentifierTree methodName, List<LiteralTree> literals) {
        List literalLocations = literals.stream().map(literal -> new JavaFileScannerContext.Location("There does not seem to be a reason to use a literal here.", (Tree)literal)).collect(Collectors.toList());
        this.reportIssue((Tree)methodName, DEFAULT_MESSAGE, literalLocations, null);
    }
}

