/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2186")
public class AssertionInThreadRunCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && AssertionInThreadRunCheck.isRunMethod(methodTree)) {
            block.accept((TreeVisitor)new AssertionsVisitor());
        }
    }

    private static boolean isRunMethod(MethodTree methodTree) {
        return methodTree.symbol().owner().type().isSubtypeOf("java.lang.Runnable") && "run".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty();
    }

    private class AssertionsVisitor
    extends BaseTreeVisitor {
        private AssertionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (UnitTestUtils.COMMON_ASSERTION_MATCHER.matches(tree)) {
                AssertionInThreadRunCheck.this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), "Remove this assertion.");
            }
            super.visitMethodInvocation(tree);
        }
    }
}

