/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2441")
public class SerializableObjectInSessionCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"javax.servlet.http.HttpSession"}).names(new String[]{"setAttribute"}).addParametersMatcher(new String[]{"java.lang.String", "*"}).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(1);
        Type type = argument.symbolType();
        if (ExpressionsHelper.isNotSerializable(argument)) {
            String andParameters = type.isParameterized() ? " and its parameters" : "";
            this.reportIssue((Tree)argument, "Make \"" + type.name() + "\"" + andParameters + " serializable or don't store it in the session.");
        }
    }
}

