/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1948")
public class SerializableFieldInSerializableClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (SerializableFieldInSerializableClassCheck.isSerializable((Tree)classTree) && !SerializableContract.hasSpecialHandlingSerializationMethods(classTree) && !classTree.symbol().type().isSubtypeOf("javax.servlet.http.HttpServlet")) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.checkVariableMember((VariableTree)member);
            }
        }
    }

    private void checkVariableMember(VariableTree variableTree) {
        if (!SerializableFieldInSerializableClassCheck.isExcluded(variableTree)) {
            IdentifierTree simpleName = variableTree.simpleName();
            if (SerializableFieldInSerializableClassCheck.isCollectionOfSerializable((Tree)variableTree.type())) {
                if (!ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.PRIVATE)) {
                    this.reportIssue((Tree)simpleName, "Make \"" + simpleName.name() + "\" private or transient.");
                } else if (SerializableFieldInSerializableClassCheck.isUnserializableCollection(variableTree.type().symbolType()) || SerializableFieldInSerializableClassCheck.isUnserializableCollection(variableTree.initializer())) {
                    this.reportIssue(simpleName);
                }
                this.checkCollectionAssignments(variableTree.symbol().usages());
            } else {
                ExpressionTree initializer = variableTree.initializer();
                Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)variableTree.symbol();
                if (initializer == null || !variableSymbol.isFinal() || !SerializableFieldInSerializableClassCheck.implementsSerializable(initializer.symbolType())) {
                    this.reportIssue(simpleName);
                }
            }
        }
    }

    private static boolean isUnserializableCollection(@Nullable ExpressionTree expression) {
        return expression != null && !expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && SerializableFieldInSerializableClassCheck.isUnserializableCollection(expression.symbolType());
    }

    private static boolean isUnserializableCollection(Type type) {
        return !type.symbol().isInterface() && SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(type) && !SerializableFieldInSerializableClassCheck.implementsSerializable(type);
    }

    private void checkCollectionAssignments(List<IdentifierTree> usages) {
        for (IdentifierTree usage : usages) {
            AssignmentExpressionTree assignment;
            Tree parentTree = usage.parent();
            if (!parentTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !usage.equals((assignment = (AssignmentExpressionTree)parentTree).variable()) || !SerializableFieldInSerializableClassCheck.isUnserializableCollection(assignment.expression())) continue;
            this.reportIssue(usage);
        }
    }

    private void reportIssue(IdentifierTree tree) {
        this.reportIssue((Tree)tree, "Make \"" + tree.name() + "\" transient or serializable.");
    }

    private static boolean isExcluded(VariableTree variableTree) {
        return SerializableFieldInSerializableClassCheck.isStatic(variableTree) || SerializableFieldInSerializableClassCheck.isTransientSerializableOrInjected(variableTree);
    }

    private static boolean isCollectionOfSerializable(Tree tree) {
        ParameterizedTypeTree typeTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) && SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi((typeTree = (ParameterizedTypeTree)tree).symbolType())) {
            return typeTree.typeArguments().stream().allMatch(SerializableFieldInSerializableClassCheck::isCollectionOfSerializable);
        }
        return SerializableFieldInSerializableClassCheck.isSerializable(tree);
    }

    private static boolean isSubtypeOfCollectionApi(Type type) {
        return type.isSubtypeOf("java.util.Collection") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean isStatic(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isTransientSerializableOrInjected(VariableTree member) {
        if (ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.TRANSIENT) || SerializableFieldInSerializableClassCheck.isSerializable((Tree)member.type()) && !SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(member.type().symbolType())) {
            return true;
        }
        SymbolMetadata metadata = member.symbol().metadata();
        return metadata.isAnnotatedWith("javax.inject.Inject") || metadata.isAnnotatedWith("javax.ejb.EJB") || metadata.annotations().stream().anyMatch(annotation -> annotation.symbol().isUnknown());
    }

    private static boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
            return SerializableFieldInSerializableClassCheck.implementsSerializable(symbol.type());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.UNBOUNDED_WILDCARD})) {
            TypeTree bound = ((WildcardTree)tree).bound();
            return bound != null && SerializableFieldInSerializableClassCheck.implementsSerializable(bound.symbolType());
        }
        return SerializableFieldInSerializableClassCheck.implementsSerializable(((TypeTree)tree).symbolType());
    }

    private static boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isUnknown() || type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return SerializableFieldInSerializableClassCheck.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isClass() || JUtils.isTypeVar((Type)type)) {
            return type.isSubtypeOf("java.io.Serializable");
        }
        return false;
    }
}

