/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5042")
public class ZipEntryCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Predicate<Type> IS_ZIP_ENTRY = type -> type.isSubtypeOf("java.util.zip.ZipEntry") || type.isSubtypeOf("org.apache.commons.compress.archivers.ArchiveEntry");
    private static final String ISSUE_MESSAGE = "Make sure that expanding this archive file is safe here.";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        if (ZipEntryCheck.isField(tree)) {
            return;
        }
        super.visitVariable(tree);
    }

    private static boolean isField(VariableTree tree) {
        return tree.symbol().owner().isTypeSymbol();
    }

    public void visitMethod(MethodTree tree) {
        if (tree.block() == null || tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            return;
        }
        tree.parameters().stream().filter(p -> IS_ZIP_ENTRY.test(p.symbol().type())).forEach(p -> this.context.reportIssue((JavaCheck)this, (Tree)p, ISSUE_MESSAGE));
        super.visitMethod(tree);
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (IS_ZIP_ENTRY.test(tree.symbolType())) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree, ISSUE_MESSAGE);
        }
        super.visitMethodInvocation(tree);
    }
}

