/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKeys;

@DeprecatedRuleKeys(value={@DeprecatedRuleKey(ruleKey="S4424", repositoryKey="squid"), @DeprecatedRuleKey(ruleKey="S4424", repositoryKey="java")})
@Rule(key="S4830")
public class ServerCertificatesCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers CHECK_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"javax.net.ssl.X509TrustManager"}).names(new String[]{"checkClientTrusted", "checkServerTrusted"}).addParametersMatcher(new String[]{"java.security.cert.X509Certificate[]", "java.lang.String"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        BlockTree blockTree = methodTree.block();
        if (blockTree == null) {
            return;
        }
        if (CHECK_MATCHER.matches(methodTree) && !ThrowExceptionVisitor.throwsException((Tree)blockTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Enable server certificate validation on this SSL/TLS connection.");
        }
    }

    private static class ThrowExceptionVisitor
    extends BaseTreeVisitor {
        boolean throwsException = false;

        private ThrowExceptionVisitor() {
        }

        private static boolean throwsException(Tree tree) {
            ThrowExceptionVisitor visitor = new ThrowExceptionVisitor();
            tree.accept((TreeVisitor)visitor);
            return visitor.throwsException;
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            super.visitThrowStatement(tree);
            this.throwsException = true;
        }

        public void visitNewClass(NewClassTree tree) {
            super.visitNewClass(tree);
            this.visitMethodSymbol(tree.constructorSymbol());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            super.visitMethodInvocation(tree);
            this.visitMethodSymbol(tree.symbol());
        }

        private void visitMethodSymbol(Symbol symbol) {
            this.throwsException = symbol.isMethodSymbol() ? (this.throwsException |= !((Symbol.MethodSymbol)symbol).thrownTypes().isEmpty()) : true;
        }
    }
}

