/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4790")
public class DataHashingCheck
extends AbstractMethodDetection {
    private static final String DIGEST_UTILS = "org.apache.commons.codec.digest.DigestUtils";
    private static final String MESSAGE = "Make sure that hashing data is safe here.";
    private static final String SECRET_KEY_FACTORY = "javax.crypto.SecretKeyFactory";
    private static final List<String> HASH_NAMES = Arrays.asList("md5", "sha1", "sha256", "sha384", "sha512");
    private static final Set<String> DIGEST_HASH_NAMES = Stream.of("Md2", "Md5", "Sha", "Sha1", "Sha256", "Sha384", "Sha512").flatMap(alg -> Stream.of("get" + alg + "Digest", alg.toLowerCase(Locale.ENGLISH), alg.toLowerCase(Locale.ENGLISH) + "Hex")).collect(Collectors.toSet());

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        MethodMatchers[] methodMatchersArray = new MethodMatchers[5];
        methodMatchersArray[0] = MethodMatchers.create().ofTypes(new String[]{"java.security.MessageDigest"}).names(new String[]{"getInstance"}).withAnyParameters().build();
        methodMatchersArray[1] = MethodMatchers.create().ofTypes(new String[]{DIGEST_UTILS}).constructor().withAnyParameters().build();
        methodMatchersArray[2] = MethodMatchers.create().ofTypes(new String[]{DIGEST_UTILS}).name(DIGEST_HASH_NAMES::contains).withAnyParameters().build();
        methodMatchersArray[3] = MethodMatchers.create().ofTypes(new String[]{"com.google.common.hash.Hashing"}).name(HASH_NAMES::contains).addWithoutParametersMatcher().build();
        methodMatchersArray[4] = MethodMatchers.create().ofTypes(new String[]{SECRET_KEY_FACTORY}).names(new String[]{"getInstance"}).withAnyParameters().build();
        return MethodMatchers.or((MethodMatchers[])methodMatchersArray);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String algorithm;
        if (mit.symbol().owner().type().is(SECRET_KEY_FACTORY) && ((algorithm = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value()) == null || !algorithm.startsWith("PBKDF2"))) {
            return;
        }
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), MESSAGE);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree.identifier(), MESSAGE);
    }
}

