/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4834")
public class ControllingPermissionsCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("org.springframework.security.access.prepost.PostAuthorize", "org.springframework.security.access.prepost.PostFilter", "org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.annotation.Secured"));
    private static final List<String> JSR_250_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("javax.annotation.security.RolesAllowed", "javax.annotation.security.PermitAll", "javax.annotation.security.DenyAll"));
    private static final String ORG_SPRINGFRAMEWORK_SECURITY_CORE_GRANTED_AUTHORITY = "org.springframework.security.core.GrantedAuthority";
    private static final List<String> INTERFACES = Collections.unmodifiableList(Arrays.asList("org.springframework.security.access.AccessDecisionVoter", "org.springframework.security.access.AccessDecisionManager", "org.springframework.security.access.AfterInvocationProvider", "org.springframework.security.access.PermissionEvaluator", "org.springframework.security.access.expression.SecurityExpressionOperations", "org.springframework.security.access.expression.method.MethodSecurityExpressionHandler", "org.springframework.security.core.GrantedAuthority", "org.springframework.security.acls.model.PermissionGrantingStrategy"));
    private static final String GLOBAL_METHOD_SECURITY_CONFIGURATION = "org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration";
    private static final String MUTABLE_ACL_SERVICE = "org.springframework.security.acls.model.MutableAclService";
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.acls.model.MutableAclService"}).names(new String[]{"createAcl", "deleteAcl", "updateAcl"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.config.annotation.web.builders.HttpSecurity"}).names(new String[]{"authorizeRequests"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        switch (tree.kind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                this.handleClassTree((ClassTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.handleNewClassTree((NewClassTree)tree);
                break;
            }
            case METHOD: {
                this.handleMethodTree((MethodTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.handleMethodInvocationTree((MethodInvocationTree)tree);
                break;
            }
        }
    }

    private void handleMethodTree(MethodTree tree) {
        ModifiersTree modifiers = tree.modifiers();
        this.checkAnnotations(modifiers, ANNOTATIONS);
        this.checkAnnotations(modifiers, JSR_250_ANNOTATIONS);
    }

    private void handleClassTree(ClassTree tree) {
        tree.superInterfaces().stream().filter(superInterface -> INTERFACES.stream().anyMatch(arg_0 -> ((Type)superInterface.symbolType()).is(arg_0))).forEach(this::reportIssue);
        TypeTree superClass = tree.superClass();
        if (superClass != null && superClass.symbolType().is(GLOBAL_METHOD_SECURITY_CONFIGURATION)) {
            this.reportIssue((Tree)superClass);
        }
        this.checkAnnotations(tree.modifiers(), JSR_250_ANNOTATIONS);
    }

    private void checkAnnotations(ModifiersTree modifiers, List<String> annotations) {
        modifiers.annotations().stream().filter(annotationTree -> annotations.stream().anyMatch(arg_0 -> ((Type)annotationTree.symbolType()).is(arg_0))).forEach(this::reportIssue);
    }

    private void handleNewClassTree(NewClassTree tree) {
        JUtils.directSuperTypes((Type)tree.symbolType()).stream().filter(directSuperType -> ControllingPermissionsCheck.isGrantedAuthority(directSuperType) || ControllingPermissionsCheck.isForbiddenForAnonymousClass(tree, directSuperType)).findFirst().ifPresent(ct -> this.reportIssue((Tree)tree.identifier()));
    }

    private static boolean isGrantedAuthority(Type dst) {
        return dst.is(ORG_SPRINGFRAMEWORK_SECURITY_CORE_GRANTED_AUTHORITY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isForbiddenForAnonymousClass(NewClassTree tree, Type dst) {
        if (tree.classBody() == null) return false;
        if (INTERFACES.stream().anyMatch(arg_0 -> ((Type)dst).is(arg_0))) return true;
        if (!dst.is(GLOBAL_METHOD_SECURITY_CONFIGURATION)) return false;
        return true;
    }

    private void handleMethodInvocationTree(MethodInvocationTree tree) {
        if (METHOD_MATCHERS.matches(tree)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree));
        }
    }

    private void reportIssue(Tree tree) {
        this.reportIssue(tree, "Make sure that Permissions are controlled safely here.");
    }
}

