/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5866")
public class UnicodeCaseCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Also use %s to correctly handle non-ASCII letters.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        new Visitor(mit).visit(regexForLiterals);
    }

    private class Visitor
    extends RegexBaseVisitor {
        final Set<JavaCharacter> problematicFlags = new HashSet<JavaCharacter>();
        boolean problematicFlagSetOutsideOfRegex = false;
        final MethodInvocationTree mit;

        Visitor(MethodInvocationTree mit) {
            this.mit = mit;
        }

        protected void visitCharacter(CharacterTree tree) {
            if (this.isProblematic(tree.codePointOrUnit())) {
                JavaCharacter character = this.getJavaCharacterForFlag(2);
                if (character == null) {
                    this.problematicFlagSetOutsideOfRegex = true;
                } else {
                    this.problematicFlags.add(character);
                }
            }
        }

        protected void after(RegexParseResult regexParseResult) {
            if (this.problematicFlagSetOutsideOfRegex) {
                AbstractRegexCheck.getFlagsTree(this.mit).ifPresent(flagsTree -> UnicodeCaseCheck.this.reportIssue((Tree)flagsTree, String.format(UnicodeCaseCheck.MESSAGE, "\"Pattern.UNICODE_CASE\"")));
            }
            for (JavaCharacter flag : this.problematicFlags) {
                UnicodeCaseCheck.this.reportIssue((RegexSyntaxElement)flag, String.format(UnicodeCaseCheck.MESSAGE, "the \"u\" flag"), null, Collections.emptyList());
            }
        }

        boolean isNonAsciiLetter(int codePointOrUnit) {
            return codePointOrUnit > 127 && Character.isLetter(codePointOrUnit);
        }

        boolean isProblematic(int codePointOrUnit) {
            return this.flagActive(2) && !this.flagActive(64) && this.isNonAsciiLetter(codePointOrUnit);
        }
    }
}

