/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.RegexScannerContext;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractRegexCheck
extends AbstractMethodDetection
implements RegexCheck {
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final MethodMatchers REGEX_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"matches"}).addParametersMatcher(new String[]{"java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"replaceAll", "replaceFirst"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"compile", "matches"}).withAnyParameters().build()});
    private RegexScannerContext regexContext;
    private final HashSet<RegexSyntaxElement> reportedRegexTrees = new HashSet();

    public final void setContext(JavaFileScannerContext context) {
        this.regexContext = (RegexScannerContext)context;
        this.reportedRegexTrees.clear();
        super.setContext(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return REGEX_METHODS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Arguments args = mit.arguments();
        if (args.isEmpty()) {
            return;
        }
        FlagSet flags = AbstractRegexCheck.getFlags(mit);
        if (!flags.contains(16)) {
            AbstractRegexCheck.getLiterals((ExpressionTree)args.get(0)).map(literals -> this.regexForLiterals(flags, (LiteralTree)literals)).ifPresent(result -> this.checkRegex((RegexParseResult)result, mit));
        }
    }

    protected final RegexParseResult regexForLiterals(FlagSet flags, LiteralTree ... literals) {
        return this.regexContext.regexForLiterals(flags, literals);
    }

    @VisibleForTesting
    protected static Optional<LiteralTree[]> getLiterals(ExpressionTree expr) {
        switch (expr.kind()) {
            case PLUS: {
                return AbstractRegexCheck.getLiteralsFromStringConcatenation((BinaryExpressionTree)expr);
            }
            case IDENTIFIER: {
                return AbstractRegexCheck.getLiteralsFromFinalVariables((IdentifierTree)expr);
            }
            case PARENTHESIZED_EXPRESSION: {
                return AbstractRegexCheck.getLiterals(ExpressionUtils.skipParentheses((ExpressionTree)expr));
            }
            case STRING_LITERAL: {
                return Optional.of(new LiteralTree[]{(LiteralTree)expr});
            }
        }
        return Optional.empty();
    }

    private static Optional<LiteralTree[]> getLiteralsFromStringConcatenation(BinaryExpressionTree expr) {
        Optional<LiteralTree[]> leftLiterals = AbstractRegexCheck.getLiterals(expr.leftOperand());
        if (!leftLiterals.isPresent()) {
            return Optional.empty();
        }
        Optional<LiteralTree[]> rightLiterals = AbstractRegexCheck.getLiterals(expr.rightOperand());
        if (!rightLiterals.isPresent()) {
            return Optional.empty();
        }
        LiteralTree[] combined = (LiteralTree[])Streams.concat((Stream[])new Stream[]{Arrays.stream(leftLiterals.get()), Arrays.stream(rightLiterals.get())}).toArray(LiteralTree[]::new);
        return Optional.of(combined);
    }

    protected static Optional<ExpressionTree> getFinalVariableInitializer(IdentifierTree identifier) {
        Symbol symbol = identifier.symbol();
        if (!symbol.isVariableSymbol()) {
            return Optional.empty();
        }
        Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)symbol;
        if (!variableSymbol.isFinal() && !JUtils.isEffectivelyFinal((Symbol.VariableSymbol)variableSymbol)) {
            return Optional.empty();
        }
        VariableTree declaration = variableSymbol.declaration();
        if (declaration == null) {
            return Optional.empty();
        }
        ExpressionTree initializer = declaration.initializer();
        if (initializer == null) {
            return Optional.empty();
        }
        return Optional.of(initializer);
    }

    private static Optional<LiteralTree[]> getLiteralsFromFinalVariables(IdentifierTree identifier) {
        return AbstractRegexCheck.getFinalVariableInitializer(identifier).flatMap(AbstractRegexCheck::getLiterals);
    }

    public abstract void checkRegex(RegexParseResult var1, MethodInvocationTree var2);

    public final void reportIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        if (this.reportedRegexTrees.add(regexTree)) {
            this.regexContext.reportIssue((RegexCheck)this, regexTree, message, cost, secondaries);
        }
    }

    public final void reportIssue(Tree javaTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        this.regexContext.reportIssue((RegexCheck)this, javaTree, message, cost, secondaries);
    }

    protected static Optional<ExpressionTree> getFlagsTree(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("compile") && mit.arguments().size() == 2) {
            return Optional.of((ExpressionTree)mit.arguments().get(1));
        }
        return Optional.empty();
    }

    private static FlagSet getFlags(MethodInvocationTree mit) {
        int flags = AbstractRegexCheck.getFlagsTree(mit).flatMap(tree -> tree.asConstant(Integer.class)).orElse(0);
        return new FlagSet(flags);
    }
}

