/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2693")
public class ThreadStartedInConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers THREAD_START = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"start"}).addWithoutParametersMatcher().build();
    private final Deque<Boolean> inMethodOrStaticInitializerOrFinalClass = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION, Tree.Kind.STATIC_INITIALIZER);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
                this.inMethodOrStaticInitializerOrFinalClass.push(((ClassTree)tree).symbol().isFinal());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER})) {
                this.inMethodOrStaticInitializerOrFinalClass.push(Boolean.TRUE);
            } else if (BooleanUtils.isFalse((Boolean)this.inMethodOrStaticInitializerOrFinalClass.peek()) && THREAD_START.matches((MethodInvocationTree)tree)) {
                this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)((MethodInvocationTree)tree)), "Move this \"start\" call to another method.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER})) {
            this.inMethodOrStaticInitializerOrFinalClass.pop();
        }
    }
}

