/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1479")
public class SwitchWithTooManyCasesCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM_CASES = 30;
    @RuleProperty(key="maximum", description="Maximum number of case", defaultValue="30")
    public int maximumCases = 30;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        if (SwitchWithTooManyCasesCheck.isSwitchOverEnum(switchStatementTree)) {
            return;
        }
        List cases = switchStatementTree.cases();
        int size = cases.size();
        if (size > this.maximumCases) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
            for (CaseGroupTree element : cases) {
                secondary.add(new JavaFileScannerContext.Location("+1", (Tree)element.labels().get(0)));
            }
            this.reportIssue((Tree)switchStatementTree.switchKeyword(), "Reduce the number of non-empty switch cases from " + size + " to at most " + this.maximumCases + ".", secondary, null);
        }
    }

    private static boolean isSwitchOverEnum(SwitchStatementTree switchStatementTree) {
        Type type = switchStatementTree.expression().symbolType();
        return type.symbol().isEnum();
    }
}

