/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S1643")
public class StringConcatenationInLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Tree> loopLevel = new LinkedList<Tree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopLevel.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!this.loopLevel.isEmpty() && StringConcatenationInLoopCheck.isStringConcatenation(tree) && this.isNotLoopLocalVar(tree) && StringConcatenationInLoopCheck.isNotArrayAccess(tree)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.variable(), "Use a StringBuilder instead.");
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isNotLoopLocalVar(AssignmentExpressionTree tree) {
        Tree parent;
        IdentifierTree idTree = StringConcatenationInLoopCheck.getIdentifierTree(tree.variable());
        Tree declaration = idTree.symbol().declaration();
        if (declaration == null) {
            return true;
        }
        Tree parentLoop = this.loopLevel.peek();
        for (parent = declaration.parent(); parent != null && !parent.equals(parentLoop); parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION})) continue;
            return true;
        }
        return parent == null;
    }

    private static boolean isNotArrayAccess(AssignmentExpressionTree tree) {
        return !tree.variable().is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION});
    }

    private static IdentifierTree getIdentifierTree(ExpressionTree tree) {
        IdentifierTree idTree = tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? StringConcatenationInLoopCheck.getIdentifierTree(((MemberSelectExpressionTree)tree).expression()) : (tree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION}) ? StringConcatenationInLoopCheck.getIdentifierTree(((ArrayAccessExpressionTree)tree).expression()) : (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) ? StringConcatenationInLoopCheck.getIdentifierTree(((MethodInvocationTree)tree).methodSelect()) : (IdentifierTree)tree));
        return idTree;
    }

    private static boolean isStringConcatenation(AssignmentExpressionTree tree) {
        return tree.symbolType().is("java.lang.String") && StringConcatenationInLoopCheck.isConcatenation(tree);
    }

    private static boolean isConcatenation(AssignmentExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            ExpressionTree expressionTree = ExpressionUtils.skipParentheses((ExpressionTree)tree.expression());
            return expressionTree.is(new Tree.Kind[]{Tree.Kind.PLUS}) && StringConcatenationInLoopCheck.concatenateVariable(tree.variable(), (BinaryExpressionTree)expressionTree);
        }
        return tree.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT});
    }

    private static boolean concatenateVariable(ExpressionTree variable, BinaryExpressionTree plus) {
        return StringConcatenationInLoopCheck.concatenateVariable(variable, plus.leftOperand()) || StringConcatenationInLoopCheck.concatenateVariable(variable, plus.rightOperand());
    }

    private static boolean concatenateVariable(ExpressionTree variable, ExpressionTree operand) {
        if (operand.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return StringConcatenationInLoopCheck.concatenateVariable(variable, (BinaryExpressionTree)operand);
        }
        return SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)operand);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.loopLevel.push((Tree)tree);
        super.visitForEachStatement(tree);
        this.loopLevel.pop();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitForStatement(tree);
        this.loopLevel.pop();
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitWhileStatement(tree);
        this.loopLevel.pop();
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitDoWhileStatement(tree);
        this.loopLevel.pop();
    }
}

